/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Tag;
import com.netflix.spectator.impl.Preconditions;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

final class TagList
implements Iterable<Tag>,
Tag {
    private final String key;
    private final String value;
    private final TagList next;
    private final int hc;
    static final TagList EMPTY = null;

    TagList(String key, String value) {
        this(key, value, EMPTY);
    }

    TagList(String key, String value, TagList next) {
        this.key = Preconditions.checkNotNull(key, "key");
        this.value = Preconditions.checkNotNull(value, "value");
        this.next = next;
        this.hc = 31 * (key.hashCode() + value.hashCode() + (next == null ? 23 : next.hashCode()));
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public Iterator<Tag> iterator() {
        final TagList root = this;
        return new Iterator<Tag>(){
            private TagList current;
            {
                this.current = root;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public Tag next() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                TagList tmp = this.current;
                this.current = this.current.next;
                return tmp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof TagList)) {
            return false;
        }
        TagList other = (TagList)obj;
        return this.key.equals(other.key) && this.value.equals(other.value) && (this.next == other.next || this.next != null && this.next.equals(other.next));
    }

    public int hashCode() {
        return this.hc;
    }

    public static TagList create(Iterable<Tag> tags) {
        if (tags instanceof TagList) {
            return (TagList)tags;
        }
        TagList head = null;
        for (Tag t : tags) {
            head = new TagList(t.key(), t.value(), head);
        }
        return head;
    }

    public static TagList create(Map<String, String> tags) {
        TagList head = null;
        for (Map.Entry<String, String> t : tags.entrySet()) {
            head = new TagList(t.getKey(), t.getValue(), head);
        }
        return head;
    }
}

