/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Meter;
import java.util.ArrayList;

abstract class CompositeMeter
implements Meter {
    protected final Id id;

    public CompositeMeter(Id id) {
        this.id = id;
    }

    protected abstract Meter[] meters();

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public boolean hasExpired() {
        for (Meter m : this.meters()) {
            if (m.hasExpired()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterable<Measurement> measure() {
        ArrayList<Measurement> ms = new ArrayList<Measurement>();
        for (Meter meter : this.meters()) {
            for (Measurement measurement : meter.measure()) {
                ms.add(measurement);
            }
        }
        return ms;
    }
}

