/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.InternalProfiler;
import org.openjdk.jmh.profile.ProfilerResult;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Result;

public class CompilerProfiler
implements InternalProfiler {
    private long startCompTime = -1L;

    @Override
    public String getDescription() {
        return "JIT compiler profiling via standard MBeans";
    }

    @Override
    public String label() {
        return "comp";
    }

    @Override
    public Collection<String> checkSupport() {
        CompilationMXBean comp = ManagementFactory.getCompilationMXBean();
        if (comp.isCompilationTimeMonitoringSupported()) {
            return Collections.emptyList();
        }
        return Collections.singleton("The MXBean is available, but compilation time monitoring is disabled.");
    }

    @Override
    public void beforeIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        CompilationMXBean comp = ManagementFactory.getCompilationMXBean();
        try {
            this.startCompTime = comp.getTotalCompilationTime();
        }
        catch (UnsupportedOperationException e) {
            this.startCompTime = -1L;
        }
    }

    @Override
    public Collection<? extends Result> afterIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        long compTime = -this.startCompTime;
        CompilationMXBean comp = ManagementFactory.getCompilationMXBean();
        try {
            compTime += comp.getTotalCompilationTime();
        }
        catch (UnsupportedOperationException e) {
            compTime = -1L;
        }
        return Arrays.asList(new ProfilerResult("@compiler.time", compTime, "ms", AggregationPolicy.AVG));
    }
}

