/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.spectator.http.websocket;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Timer;
import io.reactivex.netty.client.ClientMetricsEvent;
import io.reactivex.netty.metrics.WebSocketClientMetricEventsListener;
import io.reactivex.netty.protocol.http.websocket.WebSocketClientMetricsEvent;
import io.reactivex.netty.spectator.SpectatorUtils;
import io.reactivex.netty.spectator.tcp.TcpClientListener;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class WebSocketClientListener
extends TcpClientListener<ClientMetricsEvent<?>> {
    private final AtomicInteger inflightHandshakes;
    private final Counter processedHandshakes;
    private final Counter failedHandshakes;
    private final Counter webSocketWrites;
    private final Counter getWebSocketReads;
    private final Timer handshakeProcessingTimes;
    private final WebSocketClientMetricEventsListenerImpl delegate = new WebSocketClientMetricEventsListenerImpl();

    protected WebSocketClientListener(String monitorId) {
        super(monitorId);
        this.inflightHandshakes = SpectatorUtils.newGauge("inflightHandshakes", monitorId, new AtomicInteger());
        this.processedHandshakes = SpectatorUtils.newCounter("processedHandshakes", monitorId);
        this.failedHandshakes = SpectatorUtils.newCounter("failedHandshakes", monitorId);
        this.webSocketWrites = SpectatorUtils.newCounter("webSocketWrites", monitorId);
        this.getWebSocketReads = SpectatorUtils.newCounter("getWebSocketReads", monitorId);
        this.handshakeProcessingTimes = SpectatorUtils.newTimer("handshakeProcessingTimes", monitorId);
    }

    public static WebSocketClientListener newWebSocketListener(String monitorId) {
        return new WebSocketClientListener(monitorId);
    }

    @Override
    public void onEvent(ClientMetricsEvent<?> event, long duration, TimeUnit timeUnit, Throwable throwable, Object value) {
        if (event.getType().getClass() == WebSocketClientMetricsEvent.EventType.class) {
            this.delegate.onEvent(event, duration, timeUnit, throwable, value);
        } else {
            super.onEvent(event, duration, timeUnit, throwable, value);
        }
    }

    public long getInflightHandshakes() {
        return this.inflightHandshakes.get();
    }

    public long getProcessedHandshakes() {
        return this.processedHandshakes.count();
    }

    public long getFailedHandshakes() {
        return this.failedHandshakes.count();
    }

    public Timer getHandshakeProcessingTimes() {
        return this.handshakeProcessingTimes;
    }

    public long getWebSocketWrites() {
        return this.webSocketWrites.count();
    }

    public long getWebSocketReads() {
        return this.getWebSocketReads.count();
    }

    private class WebSocketClientMetricEventsListenerImpl
    extends WebSocketClientMetricEventsListener {
        private WebSocketClientMetricEventsListenerImpl() {
        }

        @Override
        protected void onHandshakeStart() {
            WebSocketClientListener.this.inflightHandshakes.incrementAndGet();
        }

        @Override
        protected void onHandshakeSuccess(long duration, TimeUnit timeUnit) {
            WebSocketClientListener.this.inflightHandshakes.decrementAndGet();
            WebSocketClientListener.this.processedHandshakes.increment();
            WebSocketClientListener.this.handshakeProcessingTimes.record(duration, timeUnit);
        }

        @Override
        protected void onHandshakeFailure(long duration, TimeUnit timeUnit, Throwable throwable) {
            WebSocketClientListener.this.inflightHandshakes.decrementAndGet();
            WebSocketClientListener.this.processedHandshakes.increment();
            WebSocketClientListener.this.failedHandshakes.increment();
            WebSocketClientListener.this.handshakeProcessingTimes.record(duration, timeUnit);
        }

        @Override
        protected void onWebSocketWrites() {
            WebSocketClientListener.this.webSocketWrites.increment();
        }

        @Override
        protected void onWebSocketReads() {
            WebSocketClientListener.this.getWebSocketReads.increment();
        }
    }
}

