/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.pipeline;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import io.reactivex.netty.channel.NewRxConnectionEvent;
import io.reactivex.netty.client.ConnectionReuseEvent;
import rx.Observer;

public class ObservableAdapter
extends ChannelInboundHandlerAdapter {
    private Observer bridgedObserver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (null != this.bridgedObserver) {
            try {
                this.bridgedObserver.onNext(msg);
            }
            catch (ClassCastException cce) {
                this.bridgedObserver.onError(new RuntimeException("Mismatched message type.", cce));
            }
            finally {
                ReferenceCountUtil.release(msg);
            }
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (null != this.bridgedObserver) {
            this.bridgedObserver.onError(cause);
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (null != this.bridgedObserver) {
            this.bridgedObserver.onCompleted();
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object event) throws Exception {
        if (event instanceof NewRxConnectionEvent) {
            NewRxConnectionEvent rxConnectionEvent = (NewRxConnectionEvent)event;
            this.bridgedObserver = rxConnectionEvent.getConnectedObserver();
        } else if (event instanceof ConnectionReuseEvent) {
            ConnectionReuseEvent reuseEvent = (ConnectionReuseEvent)event;
            this.bridgedObserver = reuseEvent.getConnectedObserver();
        }
        super.userEventTriggered(ctx, event);
    }
}

