/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.ws.client.internal;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.Cookie;
import io.reactivex.netty.channel.Connection;
import io.reactivex.netty.channel.ContentSource;
import io.reactivex.netty.client.ClientConnectionToChannelBridge;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.reactivex.netty.protocol.http.internal.AbstractHttpConnectionBridge;
import io.reactivex.netty.protocol.http.sse.ServerSentEvent;
import io.reactivex.netty.protocol.http.ws.WebSocketConnection;
import io.reactivex.netty.protocol.http.ws.client.WebSocketResponse;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import rx.Observable;

public final class WebSocketResponseImpl<T>
extends WebSocketResponse<T> {
    private final HttpClientResponse<T> delegate;
    private final WebSocketConnection wsConnection;
    private final Channel channel;

    public WebSocketResponseImpl(HttpClientResponse<T> delegate) {
        this.delegate = delegate;
        Connection<?, ?> cast = delegate.unsafeConnection();
        this.channel = cast.unsafeNettyChannel();
        this.wsConnection = new WebSocketConnection(cast);
    }

    @Override
    public Observable<WebSocketConnection> getWebSocketConnection() {
        if (this.isUpgraded()) {
            this.channel.attr(ClientConnectionToChannelBridge.DISCARD_CONNECTION).set((Object)true);
            this.channel.attr(AbstractHttpConnectionBridge.CONNECTION_UPGRADED).set((Object)true);
            return Observable.just((Object)this.wsConnection);
        }
        return Observable.error((Throwable)new IllegalStateException("WebSocket upgrade rejected by the server."));
    }

    @Override
    public HttpVersion getHttpVersion() {
        return this.delegate.getHttpVersion();
    }

    @Override
    public HttpResponseStatus getStatus() {
        return this.delegate.getStatus();
    }

    @Override
    public Map<String, Set<Cookie>> getCookies() {
        return this.delegate.getCookies();
    }

    @Override
    public boolean containsHeader(CharSequence name) {
        return this.delegate.containsHeader(name);
    }

    @Override
    public boolean containsHeader(CharSequence name, CharSequence value, boolean ignoreCaseValue) {
        return this.delegate.containsHeader(name, value, ignoreCaseValue);
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> headerIterator() {
        return this.delegate.headerIterator();
    }

    @Override
    public String getHeader(CharSequence name) {
        return this.delegate.getHeader(name);
    }

    @Override
    public String getHeader(CharSequence name, String defaultValue) {
        return this.delegate.getHeader(name, defaultValue);
    }

    @Override
    public List<String> getAllHeaderValues(CharSequence name) {
        return this.delegate.getAllHeaderValues(name);
    }

    @Override
    public long getContentLength() {
        return this.delegate.getContentLength();
    }

    @Override
    public long getContentLength(long defaultValue) {
        return this.delegate.getContentLength(defaultValue);
    }

    @Override
    public long getDateHeader(CharSequence name) throws ParseException {
        return this.delegate.getDateHeader(name);
    }

    @Override
    public long getDateHeader(CharSequence name, long defaultValue) {
        return this.delegate.getDateHeader(name, defaultValue);
    }

    @Override
    public String getHostHeader() {
        return this.delegate.getHostHeader();
    }

    @Override
    public String getHost(String defaultValue) {
        return this.delegate.getHost(defaultValue);
    }

    @Override
    public int getIntHeader(CharSequence name) {
        return this.delegate.getIntHeader(name);
    }

    @Override
    public int getIntHeader(CharSequence name, int defaultValue) {
        return this.delegate.getIntHeader(name, defaultValue);
    }

    @Override
    public boolean isContentLengthSet() {
        return this.delegate.isContentLengthSet();
    }

    @Override
    public boolean isKeepAlive() {
        return this.delegate.isKeepAlive();
    }

    @Override
    public boolean isTransferEncodingChunked() {
        return this.delegate.isTransferEncodingChunked();
    }

    @Override
    public Set<String> getHeaderNames() {
        return this.delegate.getHeaderNames();
    }

    @Override
    public HttpClientResponse<T> addHeader(CharSequence name, Object value) {
        return this.delegate.addHeader(name, value);
    }

    @Override
    public HttpClientResponse<T> addCookie(Cookie cookie) {
        return this.delegate.addCookie(cookie);
    }

    @Override
    public HttpClientResponse<T> addDateHeader(CharSequence name, Date value) {
        return this.delegate.addDateHeader(name, value);
    }

    @Override
    public HttpClientResponse<T> addDateHeader(CharSequence name, Iterable<Date> values) {
        return this.delegate.addDateHeader(name, values);
    }

    @Override
    public HttpClientResponse<T> addHeader(CharSequence name, Iterable<Object> values) {
        return this.delegate.addHeader(name, values);
    }

    @Override
    public HttpClientResponse<T> setDateHeader(CharSequence name, Date value) {
        return this.delegate.setDateHeader(name, value);
    }

    @Override
    public HttpClientResponse<T> setHeader(CharSequence name, Object value) {
        return this.delegate.setHeader(name, value);
    }

    @Override
    public HttpClientResponse<T> setDateHeader(CharSequence name, Iterable<Date> values) {
        return this.delegate.setDateHeader(name, values);
    }

    @Override
    public HttpClientResponse<T> setHeader(CharSequence name, Iterable<Object> values) {
        return this.delegate.setHeader(name, values);
    }

    @Override
    public HttpClientResponse<T> removeHeader(CharSequence name) {
        return this.delegate.removeHeader(name);
    }

    @Override
    public ContentSource<ServerSentEvent> getContentAsServerSentEvents() {
        return this.delegate.getContentAsServerSentEvents();
    }

    @Override
    public ContentSource<T> getContent() {
        return this.delegate.getContent();
    }

    @Override
    public Observable<Void> discardContent() {
        return this.delegate.discardContent();
    }

    @Override
    public <TT> HttpClientResponse<TT> transformContent(Observable.Transformer<T, TT> transformer) {
        return this.delegate.transformContent(transformer);
    }

    @Override
    public Channel unsafeNettyChannel() {
        return this.delegate.unsafeNettyChannel();
    }

    @Override
    public Connection<?, ?> unsafeConnection() {
        return this.delegate.unsafeConnection();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

