/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.sse.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.ByteProcessor;
import io.reactivex.netty.protocol.http.sse.ServerSentEvent;

@ChannelHandler.Sharable
public class ServerSentEventEncoder
extends ChannelOutboundHandlerAdapter {
    private static final byte[] EVENT_PREFIX_BYTES = "event: ".getBytes();
    private static final byte[] NEW_LINE_AS_BYTES = "\n".getBytes();
    private static final byte[] ID_PREFIX_AS_BYTES = "id: ".getBytes();
    private static final byte[] DATA_PREFIX_AS_BYTES = "data: ".getBytes();
    private final boolean splitSseData;

    public ServerSentEventEncoder() {
        this(false);
    }

    public ServerSentEventEncoder(boolean splitSseData) {
        this.splitSseData = splitSseData;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        Object msgToWriteFurther = msg;
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/event-stream");
        } else if (msg instanceof ServerSentEvent) {
            ServerSentEvent serverSentEvent = (ServerSentEvent)msg;
            ByteBuf out = ctx.alloc().buffer();
            msgToWriteFurther = out;
            if (serverSentEvent.hasEventType()) {
                out.writeBytes(EVENT_PREFIX_BYTES);
                out.writeBytes(serverSentEvent.getEventType());
                out.writeBytes(NEW_LINE_AS_BYTES);
            }
            if (serverSentEvent.hasEventId()) {
                out.writeBytes(ID_PREFIX_AS_BYTES);
                out.writeBytes(serverSentEvent.getEventId());
                out.writeBytes(NEW_LINE_AS_BYTES);
            }
            ByteBuf content = serverSentEvent.hasDataAsString() ? ctx.alloc().buffer().writeBytes(serverSentEvent.contentAsString().getBytes()) : serverSentEvent.content();
            if (this.splitSseData) {
                while (content.isReadable()) {
                    int readerIndexAtStart = content.readerIndex();
                    int newLineIndex = content.forEachByte(new ByteProcessor(){

                        public boolean process(byte value) throws Exception {
                            return (char)value != '\n';
                        }
                    });
                    if (-1 == newLineIndex) {
                        out.writeBytes(DATA_PREFIX_AS_BYTES);
                        out.writeBytes(content);
                        out.writeBytes(NEW_LINE_AS_BYTES);
                        continue;
                    }
                    out.writeBytes(DATA_PREFIX_AS_BYTES);
                    out.writeBytes(content, newLineIndex - readerIndexAtStart);
                    content.readerIndex(content.readerIndex() + 1);
                    out.writeBytes(NEW_LINE_AS_BYTES);
                }
            } else {
                out.writeBytes(DATA_PREFIX_AS_BYTES);
                out.writeBytes(content);
                out.writeBytes(NEW_LINE_AS_BYTES);
            }
        }
        ctx.write(msgToWriteFurther, promise);
    }
}

