/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.RecyclableArrayList;
import io.reactivex.netty.channel.AppendTransformerEvent;
import io.reactivex.netty.channel.ConnectionInputSubscriberEvent;
import io.reactivex.netty.channel.ConnectionInputSubscriberReplaceEvent;
import io.reactivex.netty.channel.SubscriberToChannelFutureBridge;
import io.reactivex.netty.channel.WriteTransformations;
import io.reactivex.netty.client.ClientConnectionToChannelBridge;
import io.reactivex.netty.events.Clock;
import io.reactivex.netty.protocol.http.internal.HttpContentSubscriberEvent;
import io.reactivex.netty.protocol.http.internal.UnsafeEmptySubscriber;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Producer;
import rx.Subscriber;
import rx.functions.Action0;
import rx.subscriptions.Subscriptions;

public abstract class AbstractHttpConnectionBridge<C>
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHttpConnectionBridge.class);
    public static final AttributeKey<Boolean> CONNECTION_UPGRADED = AttributeKey.valueOf((String)"rxnetty_http_upgraded_connection");
    private static final IllegalStateException ONLY_ONE_CONTENT_INPUT_SUB_ALLOWED = new IllegalStateException("Only one subscriber allowed for HTTP content.");
    private static final IllegalStateException LAZY_CONTENT_INPUT_SUB = new IllegalStateException("Channel is set to auto-read but the subscription was lazy.");
    private static final IllegalStateException CONTENT_ARRIVED_WITH_NO_SUB = new IllegalStateException("HTTP Content received but no subscriber was registered.");
    private static final ClosedChannelException CLOSED_CHANNEL_EXCEPTION = new ClosedChannelException();
    protected ConnectionInputSubscriber connectionInputSubscriber;
    private final UnsafeEmptySubscriber<C> emptyContentSubscriber = new UnsafeEmptySubscriber("Error while waiting for HTTP content.");
    private final WriteTransformations transformations = new WriteTransformations();
    private long headerWriteStartTimeNanos;

    protected AbstractHttpConnectionBridge() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        boolean skipNextHandlers = false;
        if (this.isOutboundHeader(msg)) {
            this.headerWriteStartTimeNanos = Clock.newStartTimeNanos();
            HttpMessage httpMsg = (HttpMessage)msg;
            if (!HttpUtil.isContentLengthSet((HttpMessage)httpMsg) && !HttpVersion.HTTP_1_0.equals((Object)httpMsg.protocolVersion())) {
                httpMsg.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            }
            this.beforeOutboundHeaderWrite(httpMsg, promise, this.headerWriteStartTimeNanos);
        } else if (msg instanceof LastHttpContent) {
            this.onOutboundLastContentWrite((LastHttpContent)msg, promise, this.headerWriteStartTimeNanos);
        } else if (this.transformations.acceptMessage(msg)) {
            RecyclableArrayList out = RecyclableArrayList.newInstance();
            try {
                this.transformations.transform(msg, ctx.alloc(), (List)out);
            }
            catch (Throwable throwable) {
                int sizeMinusOne = out.size() - 1;
                if (sizeMinusOne == 0) {
                    ctx.write(out.get(0), promise);
                } else if (sizeMinusOne > 0) {
                    ChannelPromise voidPromise = ctx.voidPromise();
                    boolean isVoidPromise = promise == voidPromise;
                    for (int i = 0; i < sizeMinusOne; ++i) {
                        ChannelPromise p = isVoidPromise ? voidPromise : ctx.newPromise();
                        ctx.write(out.get(i), p);
                    }
                    ctx.write(out.get(sizeMinusOne), promise);
                }
                out.recycle();
                skipNextHandlers = true;
                throw throwable;
            }
            int sizeMinusOne = out.size() - 1;
            if (sizeMinusOne == 0) {
                ctx.write(out.get(0), promise);
            } else if (sizeMinusOne > 0) {
                ChannelPromise voidPromise = ctx.voidPromise();
                boolean isVoidPromise = promise == voidPromise;
                for (int i = 0; i < sizeMinusOne; ++i) {
                    ChannelPromise p = isVoidPromise ? voidPromise : ctx.newPromise();
                    ctx.write(out.get(i), p);
                }
                ctx.write(out.get(sizeMinusOne), promise);
            }
            out.recycle();
            skipNextHandlers = true;
        }
        if (!skipNextHandlers) {
            super.write(ctx, msg, promise);
        }
    }

    protected abstract void beforeOutboundHeaderWrite(HttpMessage var1, ChannelPromise var2, long var3);

    protected abstract void onOutboundLastContentWrite(LastHttpContent var1, ChannelPromise var2, long var3);

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        boolean connUpgraded;
        Object eventToPropagateFurther = evt;
        Boolean connUpgradedAttr = (Boolean)ctx.channel().attr(CONNECTION_UPGRADED).get();
        boolean bl = connUpgraded = null != connUpgradedAttr ? connUpgradedAttr : false;
        if (evt instanceof ConnectionInputSubscriberEvent) {
            ConnectionInputSubscriberEvent orig = (ConnectionInputSubscriberEvent)evt;
            if (!connUpgraded) {
                ConnectionInputSubscriber _connectionInputSubscriber;
                this.connectionInputSubscriber = _connectionInputSubscriber = this.newConnectionInputSubscriber(orig, ctx.channel());
                SubscriberToChannelFutureBridge l = new SubscriberToChannelFutureBridge(){

                    protected void doOnSuccess(ChannelFuture future) {
                        AbstractHttpConnectionBridge.this.onChannelClose(_connectionInputSubscriber);
                    }

                    protected void doOnFailure(ChannelFuture future, Throwable cause) {
                        AbstractHttpConnectionBridge.this.onChannelClose(_connectionInputSubscriber);
                    }
                };
                l.bridge(ctx.channel().closeFuture(), (Subscriber)_connectionInputSubscriber);
                ConnectionInputSubscriberEvent newEvent = new ConnectionInputSubscriberEvent((Subscriber)_connectionInputSubscriber);
                eventToPropagateFurther = newEvent;
            } else {
                if (null != this.connectionInputSubscriber) {
                    this.connectionInputSubscriber.state.stage = State.Stage.Upgraded;
                }
                ConnectionInputSubscriberReplaceEvent replaceEvt = new ConnectionInputSubscriberReplaceEvent(orig);
                eventToPropagateFurther = replaceEvt;
            }
        } else if (evt instanceof HttpContentSubscriberEvent) {
            this.newHttpContentSubscriber(evt, this.connectionInputSubscriber);
        } else if (evt instanceof AppendTransformerEvent) {
            this.transformations.appendTransformer(((AppendTransformerEvent)evt).getTransformer());
        } else if (evt instanceof ClientConnectionToChannelBridge.ConnectionReuseEvent) {
            this.transformations.resetTransformations();
        }
        super.userEventTriggered(ctx, eventToPropagateFurther);
    }

    protected ConnectionInputSubscriber newConnectionInputSubscriber(ConnectionInputSubscriberEvent<?, ?> orig, Channel channel) {
        ConnectionInputSubscriber toReturn = new ConnectionInputSubscriber(orig.getSubscriber(), channel);
        toReturn.state.headerSub.add(Subscriptions.create((Action0)toReturn));
        return toReturn;
    }

    protected final void onChannelClose(ConnectionInputSubscriber connectionInputSubscriber) {
        connectionInputSubscriber.onError(CLOSED_CHANNEL_EXCEPTION);
    }

    protected void onClosedBeforeReceiveComplete(Channel channel) {
    }

    protected void resetSubscriptionState(ConnectionInputSubscriber connectionInputSubscriber) {
        connectionInputSubscriber.resetSubscribers();
    }

    protected abstract boolean isInboundHeader(Object var1);

    protected abstract boolean isOutboundHeader(Object var1);

    protected abstract Object newHttpObject(Object var1, Channel var2);

    protected abstract void onContentReceived();

    protected abstract void onContentReceiveComplete(long var1);

    protected void onNewContentSubscriber(ConnectionInputSubscriber inputSubscriber, Subscriber<? super C> newSub) {
    }

    protected long getHeaderWriteStartTimeNanos() {
        return this.headerWriteStartTimeNanos;
    }

    private void processNextItemInEventloop(Object nextItem, ConnectionInputSubscriber connectionInputSubscriber) {
        State state = connectionInputSubscriber.state;
        Channel channel = connectionInputSubscriber.channel;
        if (this.isInboundHeader(nextItem)) {
            state.headerReceived();
            Object newHttpObject = this.newHttpObject(nextItem, channel);
            connectionInputSubscriber.nextHeader(newHttpObject);
            this.checkEagerSubscriptionIfConfigured(channel, state);
            HttpObject httpObject = (HttpObject)nextItem;
            if (httpObject.decoderResult().isFailure()) {
                connectionInputSubscriber.onError(httpObject.decoderResult().cause());
                channel.close();
            }
        }
        if (nextItem instanceof HttpContent) {
            this.onContentReceived();
            ByteBuf content = ((ByteBufHolder)nextItem).content();
            if (nextItem instanceof LastHttpContent) {
                state.contentComplete();
                if (content.isReadable()) {
                    connectionInputSubscriber.nextContent(content);
                } else {
                    ReferenceCountUtil.release((Object)content);
                }
                connectionInputSubscriber.contentComplete();
                this.onContentReceiveComplete(state.headerReceivedTimeNanos);
            } else {
                connectionInputSubscriber.nextContent(content);
            }
        } else if (!this.isInboundHeader(nextItem)) {
            connectionInputSubscriber.nextContent(nextItem);
        }
    }

    private void newHttpContentSubscriber(Object evt, ConnectionInputSubscriber inputSubscriber) {
        HttpContentSubscriberEvent contentSubscriberEvent = (HttpContentSubscriberEvent)evt;
        Subscriber newSub = contentSubscriberEvent.getSubscriber();
        RuntimeException errorToRaise = null;
        if (null == inputSubscriber) {
            errorToRaise = new NullPointerException("Null Connection input subscriber.");
        } else {
            State state = inputSubscriber.state;
            if (state.raiseErrorOnInputSubscription()) {
                errorToRaise = state.raiseErrorOnInputSubscription;
            } else if (AbstractHttpConnectionBridge.isValidToEmit(state.contentSub)) {
                if (!newSub.isUnsubscribed()) {
                    errorToRaise = ONLY_ONE_CONTENT_INPUT_SUB_ALLOWED;
                }
            } else if (state.stage == State.Stage.HeaderReceived) {
                inputSubscriber.setupContentSubscriber(newSub);
                this.onNewContentSubscriber(inputSubscriber, newSub);
            } else {
                errorToRaise = new IllegalStateException("Content subscription received without request start.");
            }
        }
        if (null != errorToRaise && AbstractHttpConnectionBridge.isValidToEmit(newSub)) {
            newSub.onError((Throwable)errorToRaise);
        }
    }

    private void checkEagerSubscriptionIfConfigured(Channel channel, State state) {
        if (channel.config().isAutoRead() && null == state.contentSub) {
            state.raiseErrorOnInputSubscription = LAZY_CONTENT_INPUT_SUB;
            state.contentSub = this.emptyContentSubscriber;
        }
    }

    private static boolean isValidToEmit(Subscriber<?> subscriber) {
        return null != subscriber && !subscriber.isUnsubscribed();
    }

    static {
        ONLY_ONE_CONTENT_INPUT_SUB_ALLOWED.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
        LAZY_CONTENT_INPUT_SUB.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
        CONTENT_ARRIVED_WITH_NO_SUB.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
        CLOSED_CHANNEL_EXCEPTION.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
    }

    protected class ConnectionInputSubscriber
    extends Subscriber<Object>
    implements Action0,
    Runnable {
        private final Channel channel;
        private final State state = new State();
        private Producer producer;

        private ConnectionInputSubscriber(Subscriber subscriber, Channel channel) {
            this.channel = channel;
            this.state.headerSub = subscriber;
        }

        public void onCompleted() {
            if (this.state.startButNotCompleted()) {
                this.onError(CLOSED_CHANNEL_EXCEPTION);
            } else {
                this.completeAllSubs();
            }
        }

        public void onError(Throwable e) {
            this.errorAllSubs(e);
            if (this.state.startButNotCompleted()) {
                AbstractHttpConnectionBridge.this.onClosedBeforeReceiveComplete(this.channel);
            }
        }

        public void onNext(final Object next) {
            if (this.channel.eventLoop().inEventLoop()) {
                AbstractHttpConnectionBridge.this.processNextItemInEventloop(next, this);
            } else {
                this.channel.eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        AbstractHttpConnectionBridge.this.processNextItemInEventloop(next, ConnectionInputSubscriber.this);
                    }
                });
            }
        }

        public void setProducer(Producer producer) {
            this.producer = producer;
            this.state.headerSub.setProducer(producer);
        }

        public Channel getChannel() {
            return this.channel;
        }

        public void resetSubscribers() {
            this.completeAllSubs();
        }

        private void completeAllSubs() {
            if (AbstractHttpConnectionBridge.isValidToEmit(this.state.headerSub)) {
                this.state.headerSub.onCompleted();
            }
            if (AbstractHttpConnectionBridge.isValidToEmit(this.state.contentSub)) {
                this.state.contentSub.onCompleted();
            }
        }

        private void errorAllSubs(Throwable throwable) {
            if (AbstractHttpConnectionBridge.isValidToEmit(this.state.headerSub)) {
                this.state.headerSub.onError(throwable);
            }
            if (AbstractHttpConnectionBridge.isValidToEmit(this.state.contentSub)) {
                this.state.contentSub.onError(throwable);
            }
        }

        private void nextContent(Object nextObject) {
            if (AbstractHttpConnectionBridge.isValidToEmit(this.state.contentSub)) {
                this.state.contentSub.onNext(nextObject);
            } else {
                this.contentArrivedWhenSubscriberNotValid();
                if (logger.isWarnEnabled()) {
                    logger.warn("Data received on channel, but no subscriber registered. Discarding data. Message class: " + nextObject.getClass().getName() + ", channel: " + this.channel);
                }
                ReferenceCountUtil.release((Object)nextObject);
            }
        }

        private void nextHeader(Object nextObject) {
            if (AbstractHttpConnectionBridge.isValidToEmit(this.state.headerSub)) {
                this.state.headerSub.onNext(nextObject);
            }
        }

        private void setupContentSubscriber(Subscriber<? super C> newSub) {
            assert (this.channel.eventLoop().inEventLoop());
            this.state.contentSub = newSub;
            this.state.contentSub.add(Subscriptions.create((Action0)this));
            this.state.contentSub.setProducer(this.producer);
        }

        public void contentComplete() {
            assert (this.channel.eventLoop().inEventLoop());
            if (AbstractHttpConnectionBridge.isValidToEmit(this.state.contentSub)) {
                this.state.contentSub.onCompleted();
            } else {
                this.contentArrivedWhenSubscriberNotValid();
            }
        }

        private void contentArrivedWhenSubscriberNotValid() {
            if (null == this.state.contentSub) {
                this.state.raiseErrorOnInputSubscription = CONTENT_ARRIVED_WITH_NO_SUB;
            }
        }

        State getState() {
            return this.state;
        }

        @Override
        public void run() {
            if (this.state.contentSub != null) {
                if (this.state.contentSub.isUnsubscribed()) {
                    this.unsubscribe();
                } else if (this.state.headerSub.isUnsubscribed() && !this.state.receiveStarted()) {
                    this.unsubscribe();
                }
            } else if (this.state.headerSub.isUnsubscribed() && !this.state.receiveStarted()) {
                this.unsubscribe();
            }
        }

        public void call() {
            if (this.channel.eventLoop().inEventLoop()) {
                this.run();
            } else {
                this.channel.eventLoop().execute((Runnable)this);
            }
        }
    }

    protected static final class State {
        protected IllegalStateException raiseErrorOnInputSubscription;
        private Subscriber headerSub;
        private Subscriber contentSub;
        private long headerReceivedTimeNanos;
        private volatile Stage stage = Stage.Created;

        protected State() {
        }

        void headerReceived() {
            this.headerReceivedTimeNanos = Clock.newStartTimeNanos();
            this.stage = Stage.HeaderReceived;
        }

        private void contentComplete() {
            this.stage = Stage.ContentComplete;
        }

        public boolean raiseErrorOnInputSubscription() {
            return null != this.raiseErrorOnInputSubscription;
        }

        public boolean startButNotCompleted() {
            return this.stage == Stage.HeaderReceived;
        }

        public boolean receiveStarted() {
            return this.stage.ordinal() > Stage.Created.ordinal();
        }

        Subscriber<?> getHeaderSub() {
            return this.headerSub;
        }

        Subscriber<?> getContentSub() {
            return this.contentSub;
        }

        static enum Stage {
            Created,
            HeaderReceived,
            ContentComplete,
            Upgraded;

        }
    }
}

