/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.util.atomic;

import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import rx.internal.util.unsafe.Pow2;

public final class SpscExactAtomicArrayQueue<T>
extends AtomicReferenceArray<T>
implements Queue<T> {
    private static final long serialVersionUID = 6210984603741293445L;
    final int mask;
    final int capacitySkip;
    volatile long producerIndex;
    volatile long consumerIndex;
    static final AtomicLongFieldUpdater<SpscExactAtomicArrayQueue> PRODUCER_INDEX = AtomicLongFieldUpdater.newUpdater(SpscExactAtomicArrayQueue.class, "producerIndex");
    static final AtomicLongFieldUpdater<SpscExactAtomicArrayQueue> CONSUMER_INDEX = AtomicLongFieldUpdater.newUpdater(SpscExactAtomicArrayQueue.class, "consumerIndex");

    public SpscExactAtomicArrayQueue(int capacity) {
        super(Pow2.roundToPowerOfTwo(capacity));
        int len = this.length();
        this.mask = len - 1;
        this.capacitySkip = len - capacity;
    }

    @Override
    public boolean offer(T value) {
        if (value == null) {
            throw new NullPointerException();
        }
        long pi = this.producerIndex;
        int m = this.mask;
        int fullCheck = (int)(pi + (long)this.capacitySkip) & m;
        if (this.get(fullCheck) != null) {
            return false;
        }
        int offset = (int)pi & m;
        PRODUCER_INDEX.lazySet(this, pi + 1L);
        this.lazySet(offset, value);
        return true;
    }

    @Override
    public T poll() {
        long ci = this.consumerIndex;
        int offset = (int)ci & this.mask;
        Object value = this.get(offset);
        if (value == null) {
            return null;
        }
        CONSUMER_INDEX.lazySet(this, ci + 1L);
        this.lazySet(offset, null);
        return (T)value;
    }

    @Override
    public T peek() {
        return (T)this.get((int)this.consumerIndex & this.mask);
    }

    @Override
    public void clear() {
        while (this.poll() != null || !this.isEmpty()) {
        }
    }

    @Override
    public boolean isEmpty() {
        return this.producerIndex == this.consumerIndex;
    }

    @Override
    public int size() {
        long ci = this.consumerIndex;
        while (true) {
            long pi = this.producerIndex;
            long ci2 = this.consumerIndex;
            if (ci == ci2) {
                return (int)(pi - ci2);
            }
            ci = ci2;
        }
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T element() {
        throw new UnsupportedOperationException();
    }
}

