/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslHandler;
import io.reactivex.netty.ssl.SslCodec;
import javax.net.ssl.SSLEngine;
import rx.functions.Func1;

public class DefaultSslCodec
extends SslCodec {
    private final Func1<ByteBufAllocator, SSLEngine> engineFactory;

    public DefaultSslCodec(Func1<ByteBufAllocator, SSLEngine> engineFactory) {
        this.engineFactory = engineFactory;
    }

    public DefaultSslCodec(final SSLEngine sslEngine) {
        this(new Func1<ByteBufAllocator, SSLEngine>(){

            @Override
            public SSLEngine call(ByteBufAllocator allocator) {
                return sslEngine;
            }
        });
    }

    @Override
    protected SslHandler newSslHandler(ChannelPipeline pipeline) {
        SslHandler toReturn = new SslHandler(this.engineFactory.call(pipeline.channel().alloc()));
        this.configureHandler(toReturn);
        return toReturn;
    }

    protected void configureHandler(SslHandler handler) {
    }
}

