/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import io.reactivex.netty.HandlerNames;
import io.reactivex.netty.channel.DetachedChannelPipeline;
import io.reactivex.netty.channel.WriteTransformer;
import java.net.SocketAddress;
import rx.functions.Action1;
import rx.functions.Func0;

public abstract class ServerState<R, W> {
    protected final SocketAddress socketAddress;
    protected final ServerBootstrap bootstrap;
    protected final DetachedChannelPipeline detachedPipeline;

    protected ServerState(SocketAddress socketAddress, EventLoopGroup parent, EventLoopGroup child, Class<? extends ServerChannel> channelClass) {
        this.socketAddress = socketAddress;
        this.bootstrap = new ServerBootstrap();
        this.bootstrap.childOption(ChannelOption.AUTO_READ, false);
        this.bootstrap.group(parent, child);
        this.bootstrap.channel(channelClass);
        this.detachedPipeline = new DetachedChannelPipeline();
        this.detachedPipeline.addLast(HandlerNames.WriteTransformer.getName(), new Func0<ChannelHandler>(){

            @Override
            public ChannelHandler call() {
                return new WriteTransformer();
            }
        });
        this.bootstrap.childHandler(this.detachedPipeline.getChannelInitializer());
    }

    protected ServerState(ServerState<R, W> toCopy, ServerBootstrap newBootstrap) {
        this.socketAddress = toCopy.socketAddress;
        this.bootstrap = newBootstrap;
        this.detachedPipeline = toCopy.detachedPipeline;
        this.bootstrap.childHandler(this.detachedPipeline.getChannelInitializer());
    }

    protected ServerState(ServerState<?, ?> toCopy, DetachedChannelPipeline newPipeline) {
        ServerState toCopyCast = super.cast();
        this.socketAddress = toCopy.socketAddress;
        this.bootstrap = toCopyCast.bootstrap.clone();
        this.detachedPipeline = newPipeline;
        this.bootstrap.childHandler(this.detachedPipeline.getChannelInitializer());
    }

    protected ServerState(ServerState<R, W> toCopy, SocketAddress socketAddress) {
        this.socketAddress = socketAddress;
        this.bootstrap = toCopy.bootstrap.clone();
        this.detachedPipeline = toCopy.detachedPipeline;
        this.bootstrap.childHandler(this.detachedPipeline.getChannelInitializer());
    }

    public <T> ServerState<R, W> channelOption(ChannelOption<T> option, T value) {
        ServerState<R, W> copy = this.copyBootstrapOnly();
        copy.bootstrap.option(option, value);
        return copy;
    }

    public <T> ServerState<R, W> clientChannelOption(ChannelOption<T> option, T value) {
        ServerState<R, W> copy = this.copyBootstrapOnly();
        copy.bootstrap.childOption(option, value);
        return copy;
    }

    public <RR, WW> ServerState<RR, WW> addChannelHandlerFirst(String name, Func0<ChannelHandler> handlerFactory) {
        ServerState<RR, WW> copy = this.copy();
        copy.detachedPipeline.addFirst(name, handlerFactory);
        return copy;
    }

    public <RR, WW> ServerState<RR, WW> addChannelHandlerFirst(EventExecutorGroup group, String name, Func0<ChannelHandler> handlerFactory) {
        ServerState<RR, WW> copy = this.copy();
        copy.detachedPipeline.addFirst(group, name, handlerFactory);
        return copy;
    }

    public <RR, WW> ServerState<RR, WW> addChannelHandlerLast(String name, Func0<ChannelHandler> handlerFactory) {
        ServerState<RR, WW> copy = this.copy();
        copy.detachedPipeline.addLast(name, handlerFactory);
        return copy;
    }

    public <RR, WW> ServerState<RR, WW> addChannelHandlerLast(EventExecutorGroup group, String name, Func0<ChannelHandler> handlerFactory) {
        ServerState<RR, WW> copy = this.copy();
        copy.detachedPipeline.addLast(group, name, handlerFactory);
        return copy;
    }

    public <RR, WW> ServerState<RR, WW> addChannelHandlerBefore(String baseName, String name, Func0<ChannelHandler> handlerFactory) {
        ServerState<RR, WW> copy = this.copy();
        copy.detachedPipeline.addBefore(baseName, name, handlerFactory);
        return copy;
    }

    public <RR, WW> ServerState<RR, WW> addChannelHandlerBefore(EventExecutorGroup group, String baseName, String name, Func0<ChannelHandler> handlerFactory) {
        ServerState<RR, WW> copy = this.copy();
        copy.detachedPipeline.addBefore(group, baseName, name, handlerFactory);
        return copy;
    }

    public <RR, WW> ServerState<RR, WW> addChannelHandlerAfter(String baseName, String name, Func0<ChannelHandler> handlerFactory) {
        ServerState<RR, WW> copy = this.copy();
        copy.detachedPipeline.addAfter(baseName, name, handlerFactory);
        return copy;
    }

    public <RR, WW> ServerState<RR, WW> addChannelHandlerAfter(EventExecutorGroup group, String baseName, String name, Func0<ChannelHandler> handlerFactory) {
        ServerState<RR, WW> copy = this.copy();
        copy.detachedPipeline.addAfter(group, baseName, name, handlerFactory);
        return copy;
    }

    public <RR, WW> ServerState<RR, WW> pipelineConfigurator(Action1<ChannelPipeline> pipelineConfigurator) {
        ServerState<RR, WW> copy = this.copy();
        copy.detachedPipeline.configure(pipelineConfigurator);
        return copy;
    }

    public ServerState<R, W> enableWireLogging(final LogLevel wireLoggingLevel) {
        return this.addChannelHandlerFirst(HandlerNames.WireLogging.getName(), new Func0<ChannelHandler>(){

            @Override
            public ChannelHandler call() {
                return new LoggingHandler(wireLoggingLevel);
            }
        });
    }

    public ServerState<R, W> serverAddress(SocketAddress socketAddress) {
        return this.copy(socketAddress);
    }

    public SocketAddress getServerAddress() {
        return this.socketAddress;
    }

    ServerBootstrap getBootstrap() {
        return this.bootstrap;
    }

    protected abstract ServerState<R, W> copyBootstrapOnly();

    protected abstract <RR, WW> ServerState<RR, WW> copy();

    protected abstract ServerState<R, W> copy(SocketAddress var1);

    private <RR, WW> ServerState<RR, WW> cast() {
        return this;
    }
}

