/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.tcp.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.util.concurrent.EventExecutorGroup;
import io.reactivex.netty.events.EventSource;
import io.reactivex.netty.protocol.tcp.server.ConnectionHandler;
import io.reactivex.netty.protocol.tcp.server.TcpServerImpl;
import io.reactivex.netty.protocol.tcp.server.events.TcpServerEventListener;
import io.reactivex.netty.protocol.tcp.server.events.TcpServerEventPublisher;
import io.reactivex.netty.ssl.SslCodec;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;

public abstract class TcpServer<R, W>
implements EventSource<TcpServerEventListener> {
    public abstract <T> TcpServer<R, W> channelOption(ChannelOption<T> var1, T var2);

    public abstract <T> TcpServer<R, W> clientChannelOption(ChannelOption<T> var1, T var2);

    public abstract <RR, WW> TcpServer<RR, WW> addChannelHandlerFirst(String var1, Func0<ChannelHandler> var2);

    public abstract <RR, WW> TcpServer<RR, WW> addChannelHandlerFirst(EventExecutorGroup var1, String var2, Func0<ChannelHandler> var3);

    public abstract <RR, WW> TcpServer<RR, WW> addChannelHandlerLast(String var1, Func0<ChannelHandler> var2);

    public abstract <RR, WW> TcpServer<RR, WW> addChannelHandlerLast(EventExecutorGroup var1, String var2, Func0<ChannelHandler> var3);

    public abstract <RR, WW> TcpServer<RR, WW> addChannelHandlerBefore(String var1, String var2, Func0<ChannelHandler> var3);

    public abstract <RR, WW> TcpServer<RR, WW> addChannelHandlerBefore(EventExecutorGroup var1, String var2, String var3, Func0<ChannelHandler> var4);

    public abstract <RR, WW> TcpServer<RR, WW> addChannelHandlerAfter(String var1, String var2, Func0<ChannelHandler> var3);

    public abstract <RR, WW> TcpServer<RR, WW> addChannelHandlerAfter(EventExecutorGroup var1, String var2, String var3, Func0<ChannelHandler> var4);

    public abstract <RR, WW> TcpServer<RR, WW> pipelineConfigurator(Action1<ChannelPipeline> var1);

    public abstract TcpServer<R, W> secure(Func1<ByteBufAllocator, SSLEngine> var1);

    public abstract TcpServer<R, W> secure(SSLEngine var1);

    public abstract TcpServer<R, W> secure(SslCodec var1);

    public abstract TcpServer<R, W> unsafeSecure();

    public abstract TcpServer<R, W> enableWireLogging(LogLevel var1);

    public abstract int getServerPort();

    public abstract SocketAddress getServerAddress();

    public abstract TcpServer<R, W> start(ConnectionHandler<R, W> var1);

    public abstract void shutdown();

    public abstract void awaitShutdown();

    public abstract void awaitShutdown(long var1, TimeUnit var3);

    public abstract TcpServerEventPublisher getEventPublisher();

    public static TcpServer<ByteBuf, ByteBuf> newServer() {
        return TcpServer.newServer(0);
    }

    public static TcpServer<ByteBuf, ByteBuf> newServer(int port) {
        return new TcpServerImpl<ByteBuf, ByteBuf>(new InetSocketAddress(port));
    }

    public static TcpServer<ByteBuf, ByteBuf> newServer(int port, EventLoopGroup eventLoopGroup, Class<? extends ServerChannel> channelClass) {
        return TcpServer.newServer(port, eventLoopGroup, eventLoopGroup, channelClass);
    }

    public static TcpServer<ByteBuf, ByteBuf> newServer(int port, EventLoopGroup acceptGroup, EventLoopGroup clientGroup, Class<? extends ServerChannel> channelClass) {
        return TcpServer.newServer(new InetSocketAddress(port), acceptGroup, clientGroup, channelClass);
    }

    public static TcpServer<ByteBuf, ByteBuf> newServer(SocketAddress socketAddress) {
        return new TcpServerImpl<ByteBuf, ByteBuf>(socketAddress);
    }

    public static TcpServer<ByteBuf, ByteBuf> newServer(SocketAddress socketAddress, EventLoopGroup eventLoopGroup, Class<? extends ServerChannel> channelClass) {
        return new TcpServerImpl<ByteBuf, ByteBuf>(socketAddress, eventLoopGroup, eventLoopGroup, channelClass);
    }

    public static TcpServer<ByteBuf, ByteBuf> newServer(SocketAddress socketAddress, EventLoopGroup acceptGroup, EventLoopGroup clientGroup, Class<? extends ServerChannel> channelClass) {
        return new TcpServerImpl<ByteBuf, ByteBuf>(socketAddress, acceptGroup, clientGroup, channelClass);
    }
}

