/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.client.internal;

import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.reactivex.netty.channel.Connection;
import io.reactivex.netty.channel.FlushSelectorOperator;
import io.reactivex.netty.protocol.http.client.internal.Redirector;
import java.util.Date;
import java.util.Map;
import rx.Observable;
import rx.functions.Func1;

public final class RawRequest<I, O> {
    private final Redirector<I, O> redirector;
    private final HttpRequest headers;
    private final Observable content;
    private final Func1<?, Boolean> flushSelector;
    private final boolean hasTrailers;

    private RawRequest(HttpRequest headers, Observable content, Func1<?, Boolean> flushSelector, boolean hasTrailers, Redirector<I, O> redirector) {
        this.headers = headers;
        this.content = content;
        this.flushSelector = flushSelector;
        this.hasTrailers = hasTrailers;
        this.redirector = redirector;
    }

    public RawRequest<I, O> addHeader(CharSequence name, Object value) {
        HttpRequest headersCopy = this._copyHeaders();
        headersCopy.headers().add(name, value);
        return new RawRequest<I, O>(headersCopy, this.content, this.flushSelector, this.hasTrailers, this.redirector);
    }

    public RawRequest<I, O> addHeaders(Map<? extends CharSequence, ? extends Iterable<Object>> headers) {
        HttpRequest headersCopy = this._copyHeaders();
        for (Map.Entry<? extends CharSequence, ? extends Iterable<Object>> header : headers.entrySet()) {
            headersCopy.headers().add(header.getKey(), header.getValue());
        }
        return new RawRequest<I, O>(headersCopy, this.content, this.flushSelector, this.hasTrailers, this.redirector);
    }

    public RawRequest<I, O> addHeaderValues(CharSequence name, Iterable<Object> values) {
        HttpRequest headersCopy = this._copyHeaders();
        headersCopy.headers().add(name, values);
        return new RawRequest<I, O>(headersCopy, this.content, this.flushSelector, this.hasTrailers, this.redirector);
    }

    public RawRequest<I, O> addCookie(Cookie cookie) {
        String cookieHeader = ClientCookieEncoder.STRICT.encode(cookie);
        return this.addHeader(HttpHeaderNames.COOKIE, cookieHeader);
    }

    public RawRequest<I, O> addDateHeader(CharSequence name, Date value) {
        HttpRequest headersCopy = this._copyHeaders();
        headersCopy.headers().add(name, (Object)value);
        return new RawRequest<I, O>(headersCopy, this.content, this.flushSelector, this.hasTrailers, this.redirector);
    }

    public RawRequest<I, O> addDateHeader(CharSequence name, Iterable<Date> values) {
        HttpRequest headersCopy = this._copyHeaders();
        for (Date value : values) {
            headersCopy.headers().add(name, (Object)value);
        }
        return new RawRequest<I, O>(headersCopy, this.content, this.flushSelector, this.hasTrailers, this.redirector);
    }

    public RawRequest<I, O> setDateHeader(CharSequence name, Date value) {
        HttpRequest headersCopy = this._copyHeaders();
        headersCopy.headers().set(name, (Object)value);
        return new RawRequest<I, O>(headersCopy, this.content, this.flushSelector, this.hasTrailers, this.redirector);
    }

    public RawRequest<I, O> setHeader(CharSequence name, Object value) {
        HttpRequest headersCopy = this._copyHeaders();
        headersCopy.headers().set(name, value);
        return new RawRequest<I, O>(headersCopy, this.content, this.flushSelector, this.hasTrailers, this.redirector);
    }

    public RawRequest<I, O> setHeaders(Map<? extends CharSequence, ? extends Iterable<Object>> headers) {
        HttpRequest headersCopy = this._copyHeaders();
        for (Map.Entry<? extends CharSequence, ? extends Iterable<Object>> header : headers.entrySet()) {
            headersCopy.headers().set(header.getKey(), header.getValue());
        }
        return new RawRequest<I, O>(headersCopy, this.content, this.flushSelector, this.hasTrailers, this.redirector);
    }

    public RawRequest<I, O> setHeaderValues(CharSequence name, Iterable<Object> values) {
        HttpRequest headersCopy = this._copyHeaders();
        headersCopy.headers().set(name, values);
        return new RawRequest<I, O>(headersCopy, this.content, this.flushSelector, this.hasTrailers, this.redirector);
    }

    public RawRequest<I, O> setDateHeader(CharSequence name, Iterable<Date> values) {
        HttpRequest headersCopy = this._copyHeaders();
        boolean addNow = false;
        for (Date value : values) {
            if (addNow) {
                headersCopy.headers().add(name, (Object)value);
                continue;
            }
            headersCopy.headers().set(name, (Object)value);
            addNow = true;
        }
        return new RawRequest<I, O>(headersCopy, this.content, this.flushSelector, this.hasTrailers, this.redirector);
    }

    public RawRequest<I, O> setKeepAlive(boolean keepAlive) {
        HttpRequest headersCopy = this._copyHeaders();
        HttpUtil.setKeepAlive(headersCopy, keepAlive);
        return new RawRequest<I, O>(headersCopy, this.content, this.flushSelector, this.hasTrailers, this.redirector);
    }

    public RawRequest<I, O> setTransferEncodingChunked() {
        HttpRequest headersCopy = this._copyHeaders();
        HttpUtil.setTransferEncodingChunked(headersCopy, true);
        return new RawRequest<I, O>(headersCopy, this.content, this.flushSelector, this.hasTrailers, this.redirector);
    }

    public RawRequest<I, O> removeHeader(CharSequence name) {
        HttpRequest headersCopy = this._copyHeaders();
        headersCopy.headers().remove(name);
        return new RawRequest<I, O>(headersCopy, this.content, this.flushSelector, this.hasTrailers, this.redirector);
    }

    public RawRequest<I, O> setMethod(HttpMethod method) {
        HttpRequest headersCopy = this._copyHeaders(this.headers.uri(), method);
        return new RawRequest<I, O>(headersCopy, this.content, this.flushSelector, this.hasTrailers, this.redirector);
    }

    public RawRequest<I, O> setUri(String uri) {
        HttpRequest headersCopy = this._copyHeaders(uri, this.headers.method());
        return new RawRequest<I, O>(headersCopy, this.content, this.flushSelector, this.hasTrailers, this.redirector);
    }

    public RawRequest<I, O> followRedirect(Redirector<I, O> redirectHandler) {
        return new RawRequest<I, O>(this.headers, this.content, this.flushSelector, this.hasTrailers, redirectHandler);
    }

    public Observable asObservable(Connection<?, ?> connection) {
        Observable<HttpObject> toReturn = Observable.just(this.headers);
        if (null != this.content) {
            toReturn = null == this.flushSelector ? toReturn.concatWith(this.content) : toReturn.concatWith(this.content.lift(new FlushSelectorOperator(this.flushSelector, connection)));
        }
        if (!this.hasTrailers) {
            toReturn = toReturn.concatWith(Observable.just(LastHttpContent.EMPTY_LAST_CONTENT));
        }
        return toReturn;
    }

    private HttpRequest _copyHeaders() {
        return this._copyHeaders(this.headers.uri(), this.headers.method());
    }

    private HttpRequest _copyHeaders(String uri, HttpMethod method) {
        DefaultHttpRequest newHeaders = new DefaultHttpRequest(this.headers.protocolVersion(), method, uri);
        for (Map.Entry<String, String> header : this.headers.headers()) {
            newHeaders.headers().set(header.getKey(), (Object)header.getValue());
        }
        return newHeaders;
    }

    public static <I, O> RawRequest<I, O> create(HttpVersion version, HttpMethod httpMethod, String uri, Redirector<I, O> redirectHandler) {
        DefaultHttpRequest headers = new DefaultHttpRequest(version, httpMethod, uri);
        return RawRequest.create(headers, null, null, false, redirectHandler);
    }

    public static <I, O> RawRequest<I, O> create(HttpRequest headers, Observable content, boolean hasTrailers, Redirector<I, O> redirectHandler) {
        return RawRequest.create(headers, content, null, hasTrailers, redirectHandler);
    }

    public static <I, O> RawRequest<I, O> create(HttpRequest headers, Observable content, Func1<?, Boolean> flushSelector, boolean hasTrailers, Redirector<I, O> redirectHandler) {
        return new RawRequest<I, O>(headers, content, flushSelector, hasTrailers, redirectHandler);
    }

    public HttpRequest getHeaders() {
        return this.headers;
    }

    public Observable getContent() {
        return this.content;
    }

    public Func1<?, Boolean> getFlushSelector() {
        return this.flushSelector;
    }

    public boolean hasTrailers() {
        return this.hasTrailers;
    }

    public Redirector<I, O> getRedirector() {
        return this.redirector;
    }
}

