/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.client.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.util.ReferenceCountUtil;
import io.reactivex.netty.channel.Connection;
import io.reactivex.netty.channel.ContentSource;
import io.reactivex.netty.protocol.http.CookiesHolder;
import io.reactivex.netty.protocol.http.HttpHandlerNames;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.reactivex.netty.protocol.http.client.internal.UnusableConnection;
import io.reactivex.netty.protocol.http.internal.HttpContentSubscriberEvent;
import io.reactivex.netty.protocol.http.sse.ServerSentEvent;
import io.reactivex.netty.protocol.http.sse.client.ServerSentEventDecoder;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;

public final class HttpClientResponseImpl<T>
extends HttpClientResponse<T> {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientResponseImpl.class);
    public static final String KEEP_ALIVE_HEADER_NAME = "Keep-Alive";
    private static final Pattern PATTERN_COMMA = Pattern.compile(",");
    private static final Pattern PATTERN_EQUALS = Pattern.compile("=");
    public static final String KEEP_ALIVE_TIMEOUT_HEADER_ATTR = "timeout";
    private final HttpResponse nettyResponse;
    private final Connection<?, ?> connection;
    private final CookiesHolder cookiesHolder;
    private final ContentSource<T> contentSource;

    private HttpClientResponseImpl(HttpResponse nettyResponse) {
        this(nettyResponse, UnusableConnection.create());
    }

    private HttpClientResponseImpl(HttpResponse nettyResponse, Connection<?, ?> connection) {
        this.nettyResponse = nettyResponse;
        this.connection = connection;
        this.cookiesHolder = CookiesHolder.newClientResponseHolder(nettyResponse.headers());
        this.contentSource = new ContentSource(this.unsafeNettyChannel(), new ContentSourceSubscriptionFactory());
    }

    private HttpClientResponseImpl(HttpClientResponseImpl<?> toCopy, ContentSource<T> newSource) {
        this.nettyResponse = toCopy.nettyResponse;
        this.connection = toCopy.connection;
        this.cookiesHolder = toCopy.cookiesHolder;
        this.contentSource = newSource;
    }

    @Override
    public HttpVersion getHttpVersion() {
        return this.nettyResponse.protocolVersion();
    }

    @Override
    public HttpResponseStatus getStatus() {
        return this.nettyResponse.status();
    }

    @Override
    public Map<String, Set<Cookie>> getCookies() {
        return this.cookiesHolder.getAllCookies();
    }

    @Override
    public boolean containsHeader(CharSequence name) {
        return this.nettyResponse.headers().contains(name);
    }

    @Override
    public boolean containsHeader(CharSequence name, CharSequence value, boolean ignoreCaseValue) {
        return this.nettyResponse.headers().contains(name, value, ignoreCaseValue);
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> headerIterator() {
        return this.nettyResponse.headers().iteratorCharSequence();
    }

    @Override
    public String getHeader(CharSequence name) {
        return this.nettyResponse.headers().get(name);
    }

    @Override
    public String getHeader(CharSequence name, String defaultValue) {
        return this.nettyResponse.headers().get(name, defaultValue);
    }

    @Override
    public List<String> getAllHeaderValues(CharSequence name) {
        return this.nettyResponse.headers().getAll(name);
    }

    @Override
    public long getContentLength() {
        return HttpUtil.getContentLength(this.nettyResponse);
    }

    @Override
    public long getContentLength(long defaultValue) {
        return HttpUtil.getContentLength((HttpMessage)this.nettyResponse, defaultValue);
    }

    @Override
    public long getDateHeader(CharSequence name) {
        return this.nettyResponse.headers().getTimeMillis(name);
    }

    @Override
    public long getDateHeader(CharSequence name, long defaultValue) {
        return this.nettyResponse.headers().getTimeMillis(name, defaultValue);
    }

    @Override
    public String getHostHeader() {
        return this.nettyResponse.headers().get(HttpHeaderNames.HOST);
    }

    @Override
    public String getHost(String defaultValue) {
        return this.nettyResponse.headers().get(HttpHeaderNames.HOST, defaultValue);
    }

    @Override
    public int getIntHeader(CharSequence name) {
        return this.nettyResponse.headers().getInt(name);
    }

    @Override
    public int getIntHeader(CharSequence name, int defaultValue) {
        return this.nettyResponse.headers().getInt(name, defaultValue);
    }

    @Override
    public boolean isContentLengthSet() {
        return HttpUtil.isContentLengthSet(this.nettyResponse);
    }

    @Override
    public boolean isKeepAlive() {
        return HttpUtil.isKeepAlive(this.nettyResponse);
    }

    @Override
    public boolean isTransferEncodingChunked() {
        return HttpUtil.isTransferEncodingChunked(this.nettyResponse);
    }

    @Override
    public Set<String> getHeaderNames() {
        return this.nettyResponse.headers().names();
    }

    @Override
    public HttpClientResponse<T> addHeader(CharSequence name, Object value) {
        this.nettyResponse.headers().add(name, value);
        return this;
    }

    @Override
    public HttpClientResponse<T> addCookie(Cookie cookie) {
        this.nettyResponse.headers().add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)ClientCookieEncoder.STRICT.encode(cookie));
        return this;
    }

    @Override
    public HttpClientResponse<T> addDateHeader(CharSequence name, Date value) {
        this.nettyResponse.headers().set(name, (Object)value);
        return this;
    }

    @Override
    public HttpClientResponse<T> addDateHeader(CharSequence name, Iterable<Date> values) {
        for (Date value : values) {
            this.nettyResponse.headers().add(name, (Object)value);
        }
        return this;
    }

    @Override
    public HttpClientResponse<T> addHeader(CharSequence name, Iterable<Object> values) {
        this.nettyResponse.headers().add(name, values);
        return this;
    }

    @Override
    public HttpClientResponse<T> setDateHeader(CharSequence name, Date value) {
        this.nettyResponse.headers().set(name, (Object)value);
        return this;
    }

    @Override
    public HttpClientResponse<T> setHeader(CharSequence name, Object value) {
        this.nettyResponse.headers().set(name, value);
        return this;
    }

    @Override
    public HttpClientResponse<T> setDateHeader(CharSequence name, Iterable<Date> values) {
        for (Date value : values) {
            this.nettyResponse.headers().set(name, (Object)value);
        }
        return this;
    }

    @Override
    public HttpClientResponse<T> setHeader(CharSequence name, Iterable<Object> values) {
        this.nettyResponse.headers().set(name, values);
        return this;
    }

    @Override
    public HttpClientResponse<T> removeHeader(CharSequence name) {
        this.nettyResponse.headers().remove(name);
        return this;
    }

    @Override
    public ContentSource<ServerSentEvent> getContentAsServerSentEvents() {
        if (this.containsHeader(HttpHeaderNames.CONTENT_TYPE, "text/event-stream", false)) {
            ChannelPipeline pipeline = this.unsafeNettyChannel().pipeline();
            ChannelHandlerContext decoderCtx = pipeline.context(HttpResponseDecoder.class);
            if (null != decoderCtx) {
                pipeline.addAfter(decoderCtx.name(), HttpHandlerNames.SseClientCodec.getName(), new ServerSentEventDecoder());
            }
            return new ContentSource<ServerSentEvent>(this.unsafeNettyChannel(), new ContentSourceSubscriptionFactory());
        }
        return new ContentSource<ServerSentEvent>(new IllegalStateException("Response is not a server sent event response."));
    }

    @Override
    public ContentSource<T> getContent() {
        return this.contentSource;
    }

    @Override
    public Observable<Void> discardContent() {
        return this.getContent().map(new Func1<T, Void>(){

            @Override
            public Void call(T t) {
                ReferenceCountUtil.release(t);
                return null;
            }
        }).ignoreElements();
    }

    @Override
    public <TT> HttpClientResponse<TT> transformContent(Observable.Transformer<T, TT> transformer) {
        return new HttpClientResponseImpl<TT>(this, this.contentSource.transform(transformer));
    }

    @Override
    public Channel unsafeNettyChannel() {
        return this.unsafeConnection().unsafeNettyChannel();
    }

    @Override
    public Connection<?, ?> unsafeConnection() {
        return this.connection;
    }

    public Long getKeepAliveTimeoutSeconds() {
        String[] pairs;
        String keepAliveHeader = this.nettyResponse.headers().get(KEEP_ALIVE_HEADER_NAME);
        if (null != keepAliveHeader && !keepAliveHeader.isEmpty() && (pairs = PATTERN_COMMA.split(keepAliveHeader)) != null) {
            for (String pair : pairs) {
                String[] nameValue = PATTERN_EQUALS.split(pair.trim());
                if (nameValue == null || nameValue.length < 2) continue;
                String name = nameValue[0].trim().toLowerCase();
                String value = nameValue[1].trim();
                if (!KEEP_ALIVE_TIMEOUT_HEADER_ATTR.equals(name)) continue;
                try {
                    return Long.valueOf(value);
                }
                catch (NumberFormatException e) {
                    logger.info("Invalid HTTP keep alive timeout value. Keep alive header: " + keepAliveHeader + ", timeout attribute value: " + nameValue[1], e);
                    return null;
                }
            }
        }
        return null;
    }

    static <C> HttpClientResponseImpl<C> unsafeCreate(HttpResponse nettyResponse) {
        return new HttpClientResponseImpl(nettyResponse);
    }

    public static <C> HttpClientResponse<C> newInstance(HttpClientResponse<C> unsafeInstance, Connection<?, ?> connection) {
        HttpClientResponseImpl cast = (HttpClientResponseImpl)unsafeInstance;
        return new HttpClientResponseImpl(cast.nettyResponse, connection);
    }

    public static <C> HttpClientResponse<C> newInstance(HttpResponse nettyResponse, Connection<?, ?> connection) {
        return new HttpClientResponseImpl(nettyResponse, connection);
    }

    private static class ContentSourceSubscriptionFactory<T>
    implements Func1<Subscriber<? super T>, Object> {
        private ContentSourceSubscriptionFactory() {
        }

        @Override
        public Object call(Subscriber<? super T> subscriber) {
            return new HttpContentSubscriberEvent<T>(subscriber);
        }
    }
}

