/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.client.events;

import io.reactivex.netty.events.internal.SafeEventListener;
import io.reactivex.netty.protocol.http.client.events.HttpClientEventsListener;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

final class SafeHttpClientEventsListener
extends HttpClientEventsListener
implements SafeEventListener {
    private final HttpClientEventsListener delegate;
    private final AtomicBoolean completed = new AtomicBoolean();

    public SafeHttpClientEventsListener(HttpClientEventsListener delegate) {
        this.delegate = delegate;
    }

    @Override
    public void onCompleted() {
        if (this.completed.compareAndSet(false, true)) {
            this.delegate.onCompleted();
        }
    }

    @Override
    public void onRequestSubmitted() {
        if (!this.completed.get()) {
            this.delegate.onRequestSubmitted();
        }
    }

    @Override
    public void onRequestWriteStart() {
        if (!this.completed.get()) {
            this.delegate.onRequestWriteStart();
        }
    }

    @Override
    public void onRequestWriteComplete(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onRequestWriteComplete(duration, timeUnit);
        }
    }

    @Override
    public void onRequestWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onRequestWriteFailed(duration, timeUnit, throwable);
        }
    }

    @Override
    public void onResponseHeadersReceived(int responseCode, long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onResponseHeadersReceived(responseCode, duration, timeUnit);
        }
    }

    @Override
    public void onResponseContentReceived() {
        if (!this.completed.get()) {
            this.delegate.onResponseContentReceived();
        }
    }

    @Override
    public void onResponseReceiveComplete(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onResponseReceiveComplete(duration, timeUnit);
        }
    }

    @Override
    public void onResponseFailed(Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onResponseFailed(throwable);
        }
    }

    @Override
    public void onRequestProcessingComplete(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onRequestProcessingComplete(duration, timeUnit);
        }
    }

    @Override
    public void onConnectStart() {
        if (!this.completed.get()) {
            this.delegate.onConnectStart();
        }
    }

    @Override
    public void onConnectSuccess(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onConnectSuccess(duration, timeUnit);
        }
    }

    @Override
    public void onConnectFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onConnectFailed(duration, timeUnit, throwable);
        }
    }

    @Override
    public void onPoolReleaseStart() {
        if (!this.completed.get()) {
            this.delegate.onPoolReleaseStart();
        }
    }

    @Override
    public void onPoolReleaseSuccess(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onPoolReleaseSuccess(duration, timeUnit);
        }
    }

    @Override
    public void onPoolReleaseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onPoolReleaseFailed(duration, timeUnit, throwable);
        }
    }

    @Override
    public void onPooledConnectionEviction() {
        if (!this.completed.get()) {
            this.delegate.onPooledConnectionEviction();
        }
    }

    @Override
    public void onPooledConnectionReuse() {
        if (!this.completed.get()) {
            this.delegate.onPooledConnectionReuse();
        }
    }

    @Override
    public void onPoolAcquireStart() {
        if (!this.completed.get()) {
            this.delegate.onPoolAcquireStart();
        }
    }

    @Override
    public void onPoolAcquireSuccess(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onPoolAcquireSuccess(duration, timeUnit);
        }
    }

    @Override
    public void onPoolAcquireFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onPoolAcquireFailed(duration, timeUnit, throwable);
        }
    }

    @Override
    public void onByteRead(long bytesRead) {
        if (!this.completed.get()) {
            this.delegate.onByteRead(bytesRead);
        }
    }

    @Override
    public void onByteWritten(long bytesWritten) {
        if (!this.completed.get()) {
            this.delegate.onByteWritten(bytesWritten);
        }
    }

    @Override
    public void onFlushStart() {
        if (!this.completed.get()) {
            this.delegate.onFlushStart();
        }
    }

    @Override
    public void onFlushComplete(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onFlushComplete(duration, timeUnit);
        }
    }

    @Override
    public void onWriteStart() {
        if (!this.completed.get()) {
            this.delegate.onWriteStart();
        }
    }

    @Override
    public void onWriteSuccess(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onWriteSuccess(duration, timeUnit);
        }
    }

    @Override
    public void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onWriteFailed(duration, timeUnit, throwable);
        }
    }

    @Override
    public void onConnectionCloseStart() {
        if (!this.completed.get()) {
            this.delegate.onConnectionCloseStart();
        }
    }

    @Override
    public void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onConnectionCloseSuccess(duration, timeUnit);
        }
    }

    @Override
    public void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onConnectionCloseFailed(duration, timeUnit, throwable);
        }
    }

    @Override
    public void onCustomEvent(Object event) {
        if (!this.completed.get()) {
            this.delegate.onCustomEvent(event);
        }
    }

    @Override
    public void onCustomEvent(Object event, long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onCustomEvent(event, duration, timeUnit);
        }
    }

    @Override
    public void onCustomEvent(Object event, long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onCustomEvent(event, duration, timeUnit, throwable);
        }
    }

    public HttpClientEventsListener unwrap() {
        return this.delegate;
    }

    @Override
    public void onCustomEvent(Object event, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onCustomEvent(event, throwable);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafeHttpClientEventsListener)) {
            return false;
        }
        SafeHttpClientEventsListener that = (SafeHttpClientEventsListener)o;
        return !(this.delegate == null ? that.delegate != null : !this.delegate.equals(that.delegate));
    }

    public int hashCode() {
        return this.delegate != null ? this.delegate.hashCode() : 0;
    }
}

