/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.client.events;

import io.reactivex.netty.events.EventPublisher;
import io.reactivex.netty.events.EventSource;
import io.reactivex.netty.events.ListenersHolder;
import io.reactivex.netty.events.internal.SafeEventListener;
import io.reactivex.netty.protocol.http.client.events.HttpClientEventsListener;
import io.reactivex.netty.protocol.http.client.events.SafeHttpClientEventsListener;
import io.reactivex.netty.protocol.tcp.client.events.TcpClientEventListener;
import io.reactivex.netty.protocol.tcp.client.events.TcpClientEventPublisher;
import java.util.concurrent.TimeUnit;
import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Action2;
import rx.functions.Action3;
import rx.functions.Action4;
import rx.subscriptions.CompositeSubscription;

public final class HttpClientEventPublisher
extends HttpClientEventsListener
implements EventSource<HttpClientEventsListener>,
EventPublisher {
    private static final Action1<HttpClientEventsListener> REQUEST_SUBMIT_ACTION = new Action1<HttpClientEventsListener>(){

        @Override
        public void call(HttpClientEventsListener listener) {
            listener.onRequestSubmitted();
        }
    };
    private static final Action1<HttpClientEventsListener> REQUEST_WRITE_START_ACTION = new Action1<HttpClientEventsListener>(){

        @Override
        public void call(HttpClientEventsListener listener) {
            listener.onRequestWriteStart();
        }
    };
    private static final Action3<HttpClientEventsListener, Long, TimeUnit> REQUEST_WRITE_COMPLETE_ACTION = new Action3<HttpClientEventsListener, Long, TimeUnit>(){

        @Override
        public void call(HttpClientEventsListener listener, Long duration, TimeUnit timeUnit) {
            listener.onRequestWriteComplete(duration, timeUnit);
        }
    };
    private static final Action4<HttpClientEventsListener, Long, TimeUnit, Throwable> REQUEST_WRITE_FAILED_ACTION = new Action4<HttpClientEventsListener, Long, TimeUnit, Throwable>(){

        @Override
        public void call(HttpClientEventsListener listener, Long duration, TimeUnit timeUnit, Throwable t) {
            listener.onRequestWriteFailed(duration, timeUnit, t);
        }
    };
    private static final Action4<HttpClientEventsListener, Long, TimeUnit, Integer> RESP_HEADER_RECIEVED_ACTION = new Action4<HttpClientEventsListener, Long, TimeUnit, Integer>(){

        @Override
        public void call(HttpClientEventsListener listener, Long duration, TimeUnit timeUnit, Integer responseCode) {
            listener.onResponseHeadersReceived(responseCode, duration, timeUnit);
        }
    };
    private static final Action1<HttpClientEventsListener> RESP_CONTENT_RECIEVED_ACTION = new Action1<HttpClientEventsListener>(){

        @Override
        public void call(HttpClientEventsListener listener) {
            listener.onResponseContentReceived();
        }
    };
    private static final Action3<HttpClientEventsListener, Long, TimeUnit> RESP_RECIEVE_COMPLETE_ACTION = new Action3<HttpClientEventsListener, Long, TimeUnit>(){

        @Override
        public void call(HttpClientEventsListener listener, Long duration, TimeUnit timeUnit) {
            listener.onResponseReceiveComplete(duration, timeUnit);
        }
    };
    private static final Action2<HttpClientEventsListener, Throwable> RESP_FAILED_ACTION = new Action2<HttpClientEventsListener, Throwable>(){

        @Override
        public void call(HttpClientEventsListener listener, Throwable t) {
            listener.onResponseFailed(t);
        }
    };
    private static final Action3<HttpClientEventsListener, Long, TimeUnit> PROCESSING_COMPLETE_ACTION = new Action3<HttpClientEventsListener, Long, TimeUnit>(){

        @Override
        public void call(HttpClientEventsListener listener, Long duration, TimeUnit timeUnit) {
            listener.onRequestProcessingComplete(duration, timeUnit);
        }
    };
    private final ListenersHolder<HttpClientEventsListener> listeners;
    private final TcpClientEventPublisher tcpDelegate;

    public HttpClientEventPublisher() {
        this.listeners = new ListenersHolder();
        this.tcpDelegate = new TcpClientEventPublisher();
    }

    private HttpClientEventPublisher(ListenersHolder<HttpClientEventsListener> l, TcpClientEventPublisher tcpDelegate) {
        this.listeners = new ListenersHolder<HttpClientEventsListener>(l);
        this.tcpDelegate = tcpDelegate;
    }

    @Override
    public void onRequestSubmitted() {
        this.listeners.invokeListeners(REQUEST_SUBMIT_ACTION);
    }

    @Override
    public void onRequestWriteStart() {
        this.listeners.invokeListeners(REQUEST_WRITE_START_ACTION);
    }

    @Override
    public void onRequestWriteComplete(long duration, TimeUnit timeUnit) {
        this.listeners.invokeListeners(REQUEST_WRITE_COMPLETE_ACTION, duration, timeUnit);
    }

    @Override
    public void onRequestWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.listeners.invokeListeners(REQUEST_WRITE_FAILED_ACTION, duration, timeUnit, throwable);
    }

    @Override
    public void onResponseHeadersReceived(int responseCode, long duration, TimeUnit timeUnit) {
        this.listeners.invokeListeners(RESP_HEADER_RECIEVED_ACTION, duration, timeUnit, responseCode);
    }

    @Override
    public void onResponseContentReceived() {
        this.listeners.invokeListeners(RESP_CONTENT_RECIEVED_ACTION);
    }

    @Override
    public void onResponseReceiveComplete(long duration, TimeUnit timeUnit) {
        this.listeners.invokeListeners(RESP_RECIEVE_COMPLETE_ACTION, duration, timeUnit);
    }

    @Override
    public void onResponseFailed(Throwable throwable) {
        this.listeners.invokeListeners(RESP_FAILED_ACTION, throwable);
    }

    @Override
    public void onRequestProcessingComplete(long duration, TimeUnit timeUnit) {
        this.listeners.invokeListeners(PROCESSING_COMPLETE_ACTION, duration, timeUnit);
    }

    @Override
    public void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onConnectionCloseFailed(duration, timeUnit, throwable);
    }

    @Override
    public void onConnectStart() {
        this.tcpDelegate.onConnectStart();
    }

    @Override
    public void onConnectSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onConnectSuccess(duration, timeUnit);
    }

    @Override
    public void onConnectFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onConnectFailed(duration, timeUnit, throwable);
    }

    @Override
    public void onPoolReleaseStart() {
        this.tcpDelegate.onPoolReleaseStart();
    }

    @Override
    public void onPoolReleaseSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onPoolReleaseSuccess(duration, timeUnit);
    }

    @Override
    public void onPoolReleaseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onPoolReleaseFailed(duration, timeUnit, throwable);
    }

    @Override
    public void onPooledConnectionEviction() {
        this.tcpDelegate.onPooledConnectionEviction();
    }

    @Override
    public void onPooledConnectionReuse() {
        this.tcpDelegate.onPooledConnectionReuse();
    }

    @Override
    public void onPoolAcquireStart() {
        this.tcpDelegate.onPoolAcquireStart();
    }

    @Override
    public void onPoolAcquireSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onPoolAcquireSuccess(duration, timeUnit);
    }

    @Override
    public void onPoolAcquireFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onPoolAcquireFailed(duration, timeUnit, throwable);
    }

    @Override
    public void onByteRead(long bytesRead) {
        this.tcpDelegate.onByteRead(bytesRead);
    }

    @Override
    public void onByteWritten(long bytesWritten) {
        this.tcpDelegate.onByteWritten(bytesWritten);
    }

    @Override
    public void onFlushStart() {
        this.tcpDelegate.onFlushStart();
    }

    @Override
    public void onFlushComplete(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onFlushComplete(duration, timeUnit);
    }

    @Override
    public void onWriteStart() {
        this.tcpDelegate.onWriteStart();
    }

    @Override
    public void onWriteSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onWriteSuccess(duration, timeUnit);
    }

    @Override
    public void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onWriteFailed(duration, timeUnit, throwable);
    }

    @Override
    public void onConnectionCloseStart() {
        this.tcpDelegate.onConnectionCloseStart();
    }

    @Override
    public void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onConnectionCloseSuccess(duration, timeUnit);
    }

    @Override
    public void onCustomEvent(Object event) {
        this.tcpDelegate.onCustomEvent(event);
    }

    @Override
    public void onCustomEvent(Object event, long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onCustomEvent(event, duration, timeUnit);
    }

    @Override
    public void onCustomEvent(Object event, long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onCustomEvent(event, duration, timeUnit, throwable);
    }

    @Override
    public void onCustomEvent(Object event, Throwable throwable) {
        this.tcpDelegate.onCustomEvent(event, throwable);
    }

    @Override
    public boolean publishingEnabled() {
        return this.listeners.publishingEnabled();
    }

    @Override
    public Subscription subscribe(HttpClientEventsListener listener) {
        if (!SafeEventListener.class.isAssignableFrom(listener.getClass())) {
            listener = new SafeHttpClientEventsListener(listener);
        }
        CompositeSubscription cs = new CompositeSubscription();
        cs.add(this.listeners.subscribe(listener));
        HttpClientEventsListener tcpListener = listener;
        if (listener instanceof SafeHttpClientEventsListener) {
            tcpListener = ((SafeHttpClientEventsListener)listener).unwrap();
        }
        cs.add(this.tcpDelegate.subscribe(tcpListener));
        return cs;
    }

    public EventSource<TcpClientEventListener> asTcpEventSource() {
        return new EventSource<TcpClientEventListener>(){

            @Override
            public Subscription subscribe(TcpClientEventListener listener) {
                if (listener instanceof HttpClientEventsListener) {
                    return HttpClientEventPublisher.this.subscribe((HttpClientEventsListener)listener);
                }
                return HttpClientEventPublisher.this.tcpDelegate.subscribe(listener);
            }
        };
    }

    public HttpClientEventPublisher copy() {
        return new HttpClientEventPublisher(this.listeners.copy(), this.tcpDelegate.copy());
    }

    ListenersHolder<HttpClientEventsListener> getListeners() {
        return this.listeners;
    }

    TcpClientEventListener getTcpDelegate() {
        return this.tcpDelegate;
    }
}

