/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.client.pool;

import io.reactivex.netty.client.pool.FIFOIdleConnectionsHolder;
import io.reactivex.netty.client.pool.IdleConnectionsHolder;
import io.reactivex.netty.client.pool.MaxConnectionsBasedStrategy;
import io.reactivex.netty.client.pool.PoolLimitDeterminationStrategy;
import io.reactivex.netty.client.pool.UnboundedPoolLimitDeterminationStrategy;
import java.util.concurrent.TimeUnit;
import rx.Observable;

public class PoolConfig<W, R> {
    public static final long DEFAULT_MAX_IDLE_TIME_MILLIS = TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS);
    private Observable<Long> idleConnCleanupTicker;
    private PoolLimitDeterminationStrategy limitDeterminationStrategy;
    private IdleConnectionsHolder<W, R> idleConnectionsHolder;
    private long maxIdleTimeMillis = DEFAULT_MAX_IDLE_TIME_MILLIS;

    public PoolConfig() {
        this.idleConnCleanupTicker = Observable.timer(this.maxIdleTimeMillis, TimeUnit.MILLISECONDS);
        this.idleConnectionsHolder = new FIFOIdleConnectionsHolder();
        this.limitDeterminationStrategy = UnboundedPoolLimitDeterminationStrategy.INSTANCE;
    }

    public long getMaxIdleTimeMillis() {
        return this.maxIdleTimeMillis;
    }

    public Observable<Long> getIdleConnectionsCleanupTimer() {
        return this.idleConnCleanupTicker;
    }

    public PoolLimitDeterminationStrategy getPoolLimitDeterminationStrategy() {
        return this.limitDeterminationStrategy;
    }

    public PoolConfig<W, R> maxConnections(int maxConnections) {
        this.limitDeterminationStrategy = new MaxConnectionsBasedStrategy(maxConnections);
        return this;
    }

    public PoolConfig<W, R> maxIdleTimeoutMillis(long maxIdleTimeoutMillis) {
        this.maxIdleTimeMillis = maxIdleTimeoutMillis;
        return this;
    }

    public PoolConfig<W, R> limitDeterminationStrategy(PoolLimitDeterminationStrategy strategy) {
        this.limitDeterminationStrategy = strategy;
        return this;
    }

    public PoolLimitDeterminationStrategy getLimitDeterminationStrategy() {
        return this.limitDeterminationStrategy;
    }

    public PoolConfig<W, R> idleConnectionsHolder(IdleConnectionsHolder<W, R> holder) {
        this.idleConnectionsHolder = holder;
        return this;
    }

    public IdleConnectionsHolder<W, R> getIdleConnectionsHolder() {
        return this.idleConnectionsHolder;
    }

    public PoolConfig<W, R> idleConnectionsCleanupTimer(Observable<Long> timer) {
        this.idleConnCleanupTicker = timer;
        return this;
    }

    public Observable<Long> getIdleConnCleanupTicker() {
        return this.idleConnCleanupTicker;
    }
}

