/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.plaintext;

import io.netty.buffer.ByteBuf;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.protocol.http.server.HttpServer;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.reactivex.netty.protocol.http.server.RequestHandler;
import rx.Observable;

public final class PlainTextServer {
    static final int DEFAULT_PORT = 8111;
    public static final String WELCOME_MSG = "Welcome!!";
    private static final byte[] WELCOME_MSG_BYTES = "Welcome!!".getBytes();
    private static final String CONTENT_LENGTH_HEADER_VAL = String.valueOf(WELCOME_MSG_BYTES.length);
    private final int port;

    public PlainTextServer(int port) {
        this.port = port;
    }

    public HttpServer<ByteBuf, ByteBuf> createServer() {
        HttpServer server = RxNetty.createHttpServer((int)this.port, (RequestHandler)new RequestHandler<ByteBuf, ByteBuf>(){

            public Observable<Void> handle(HttpServerRequest<ByteBuf> request, HttpServerResponse<ByteBuf> response) {
                response.flushOnlyOnChannelReadComplete(true);
                response.getHeaders().set("Content-Length", (Object)CONTENT_LENGTH_HEADER_VAL);
                ByteBuf content = response.getAllocator().buffer(WELCOME_MSG_BYTES.length).writeBytes(WELCOME_MSG_BYTES);
                response.write((Object)content);
                return response.close(false);
            }
        });
        return server;
    }

    public static void main(String[] args) throws InterruptedException {
        HttpServer<ByteBuf, ByteBuf> server = new PlainTextServer(8111).createServer();
        server.start();
        System.out.println("HTTP plain text server started at port: " + server.getServerPort());
        server.waitTillShutdown();
    }
}

