/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.tcp.cpuintensive;

import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.channel.ConnectionHandler;
import io.reactivex.netty.channel.ObservableConnection;
import io.reactivex.netty.channel.RxDefaultThreadFactory;
import io.reactivex.netty.pipeline.PipelineConfigurators;
import io.reactivex.netty.server.RxServer;
import io.reactivex.netty.server.ServerBuilder;
import java.util.concurrent.ThreadFactory;
import rx.Observable;
import rx.functions.Func1;

public final class CPUIntensiveServer {
    static final int DEFAULT_PORT = 8791;
    private final int port;

    public CPUIntensiveServer(int port) {
        this.port = port;
    }

    public RxServer<String, String> createServer() {
        RxServer server = (RxServer)((ServerBuilder)((ServerBuilder)RxNetty.newTcpServerBuilder((int)this.port, (ConnectionHandler)new ConnectionHandler<String, String>(){

            public Observable<Void> handle(final ObservableConnection<String, String> connection) {
                System.out.println("New client connection established.");
                connection.writeAndFlush((Object)"Welcome! \n\n");
                return connection.getInput().flatMap((Func1)new Func1<String, Observable<Void>>(){

                    public Observable<Void> call(String msg) {
                        System.out.println("onNext: " + msg);
                        msg = msg.trim();
                        if (!msg.isEmpty()) {
                            return connection.writeAndFlush((Object)("echo => " + msg + '\n'));
                        }
                        return Observable.empty();
                    }
                });
            }
        }).pipelineConfigurator(PipelineConfigurators.textOnlyConfigurator())).withEventExecutorGroup((EventExecutorGroup)new DefaultEventExecutorGroup(50, (ThreadFactory)new RxDefaultThreadFactory("rx-connection-processor")))).build();
        return server;
    }

    public static void main(String[] args) {
        new CPUIntensiveServer(8791).createServer().startAndWait();
    }
}

