/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.logtail;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.logging.LogLevel;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.examples.http.logtail.LogEvent;
import io.reactivex.netty.pipeline.PipelineConfigurators;
import io.reactivex.netty.protocol.http.client.HttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientBuilder;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.reactivex.netty.protocol.http.sse.ServerSentEvent;
import java.util.ArrayList;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;

public class LogTailClient {
    static final int DEFAULT_TAIL_SIZE = 25;
    private final int port;
    private final int tailSize;

    public LogTailClient(int port, int tailSize) {
        this.port = port;
        this.tailSize = tailSize;
    }

    public List<LogEvent> collectEventLogs() {
        HttpClient client = (HttpClient)((HttpClientBuilder)((HttpClientBuilder)RxNetty.newHttpClientBuilder((String)"localhost", (int)this.port).enableWireLogging(LogLevel.DEBUG)).pipelineConfigurator(PipelineConfigurators.clientSseConfigurator())).build();
        Iterable eventIterable = client.submit(HttpClientRequest.createGet((String)"/logstream")).flatMap((Func1)new Func1<HttpClientResponse<ServerSentEvent>, Observable<ServerSentEvent>>(){

            public Observable<ServerSentEvent> call(HttpClientResponse<ServerSentEvent> response) {
                if (response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                    return response.getContent();
                }
                return Observable.error((Throwable)new IllegalStateException("server returned status " + response.getStatus()));
            }
        }).map((Func1)new Func1<ServerSentEvent, LogEvent>(){

            public LogEvent call(ServerSentEvent serverSentEvent) {
                return LogEvent.fromCSV(serverSentEvent.contentAsString());
            }
        }).filter((Func1)new Func1<LogEvent, Boolean>(){

            public Boolean call(LogEvent logEvent) {
                return logEvent.getLevel() == LogEvent.LogLevel.ERROR;
            }
        }).take(this.tailSize).toBlocking().toIterable();
        ArrayList<LogEvent> logs = new ArrayList<LogEvent>();
        for (LogEvent e : eventIterable) {
            System.out.println("event " + logs.size() + ": " + e);
            logs.add(e);
        }
        return logs;
    }

    public static void main(String[] args) {
        LogTailClient client = new LogTailClient(8091, 25);
        List<LogEvent> logEvents = client.collectEventLogs();
        System.out.printf("LogTailClient service collected %d entries", logEvents.size());
    }
}

