/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openjdk.jmh.util.Multiset;

public class HashMultiset<T>
implements Multiset<T>,
Serializable {
    private final Map<T, Integer> map = new HashMap<T, Integer>();
    private int size;

    @Override
    public void add(T element) {
        this.add(element, 1);
    }

    @Override
    public void add(T element, int add) {
        Integer count = this.map.get(element);
        if (count == null) {
            count = 0;
        }
        count = count + add;
        this.size += add;
        if (count != 0) {
            this.map.put(element, count);
        } else {
            this.map.remove(element);
        }
    }

    @Override
    public int count(T element) {
        Integer count = this.map.get(element);
        return count == null ? 0 : count;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Collection<T> keys() {
        return Collections.unmodifiableCollection(this.map.keySet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashMultiset that = (HashMultiset)o;
        if (this.size != that.size) {
            return false;
        }
        return ((Object)this.map).equals(that.map);
    }

    public int hashCode() {
        int result = ((Object)this.map).hashCode();
        result = 31 * result + this.size;
        return result;
    }
}

