/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.text;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import java.util.List;

class StringLineDecoder
extends ReplayingDecoder<State> {
    public StringLineDecoder() {
        super(State.NEW_LINE);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        switch ((State)((Object)this.state())) {
            case NEW_LINE: {
                String line = this.readFullLine(in);
                this.checkpoint();
                out.add(line);
                break;
            }
            case END_OF_LINE: {
                this.skipLineDelimiters(in);
            }
        }
    }

    private String readFullLine(ByteBuf in) {
        StringBuilder line = new StringBuilder();
        while (true) {
            char c;
            if (StringLineDecoder.isLineDelimiter(c = (char)in.readByte())) {
                this.checkpoint(State.END_OF_LINE);
                return line.toString();
            }
            line.append(c);
        }
    }

    private void skipLineDelimiters(ByteBuf in) {
        char c;
        while (StringLineDecoder.isLineDelimiter(c = (char)in.readByte())) {
        }
        in.readerIndex(in.readerIndex() - 1);
        this.checkpoint(State.NEW_LINE);
    }

    public static boolean isLineDelimiter(char c) {
        return c == '\r' || c == '\n';
    }

    public static enum State {
        NEW_LINE,
        END_OF_LINE;

    }
}

