/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.contexts.http;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.reactivex.netty.contexts.RequestCorrelator;
import io.reactivex.netty.contexts.RequestIdProvider;
import io.reactivex.netty.contexts.http.HttpServerContextHandler;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;

public class HttpServerContextConfigurator<I, O>
implements PipelineConfigurator<HttpServerRequest<I>, HttpServerResponse<O>> {
    public static final String CTX_HANDLER_NAME = "http-server-context-handler";
    private final RequestCorrelator correlator;
    private final RequestIdProvider requestIdProvider;
    private final PipelineConfigurator<HttpServerRequest<I>, HttpServerResponse<O>> httpConfigurator;

    public HttpServerContextConfigurator(RequestIdProvider requestIdProvider, RequestCorrelator correlator, PipelineConfigurator<HttpServerRequest<I>, HttpServerResponse<O>> httpConfigurator) {
        this.requestIdProvider = requestIdProvider;
        this.correlator = correlator;
        this.httpConfigurator = httpConfigurator;
    }

    @Override
    public void configureNewPipeline(ChannelPipeline pipeline) {
        this.httpConfigurator.configureNewPipeline(pipeline);
        pipeline.addLast(CTX_HANDLER_NAME, (ChannelHandler)new HttpServerContextHandler(this.requestIdProvider, this.correlator));
    }
}

