/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.contexts;

import io.netty.buffer.ByteBuf;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.contexts.ContextPipelineConfigurators;
import io.reactivex.netty.contexts.RequestCorrelator;
import io.reactivex.netty.contexts.RequestIdProvider;
import io.reactivex.netty.contexts.ThreadLocalRequestCorrelator;
import io.reactivex.netty.contexts.http.HttpContextClientChannelFactory;
import io.reactivex.netty.contexts.http.HttpRequestIdProvider;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import io.reactivex.netty.protocol.http.client.HttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientBuilder;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.reactivex.netty.protocol.http.server.HttpServer;
import io.reactivex.netty.protocol.http.server.HttpServerBuilder;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.reactivex.netty.protocol.http.server.RequestHandler;

public final class RxContexts {
    public static final ThreadLocalRequestCorrelator DEFAULT_CORRELATOR = new ThreadLocalRequestCorrelator();
    private static String defaultRequestIdContextKeyName = "X-RXNETTY-REQUEST-ID";

    private RxContexts() {
    }

    public static <I, O> HttpServerBuilder<I, O> newHttpServerBuilder(int port, RequestHandler<I, O> requestHandler, RequestCorrelator correlator) {
        HttpRequestIdProvider provider = new HttpRequestIdProvider(defaultRequestIdContextKeyName, correlator);
        return RxContexts.newHttpServerBuilder(port, requestHandler, provider, correlator);
    }

    public static <I, O> HttpServerBuilder<I, O> newHttpServerBuilder(int port, RequestHandler<I, O> requestHandler, RequestCorrelator correlator, PipelineConfigurator<HttpServerRequest<I>, HttpServerResponse<O>> configurator) {
        HttpRequestIdProvider provider = new HttpRequestIdProvider(defaultRequestIdContextKeyName, correlator);
        return RxContexts.newHttpServerBuilder(port, requestHandler, provider, correlator, configurator);
    }

    public static <I, O> HttpServerBuilder<I, O> newHttpServerBuilder(int port, RequestHandler<I, O> requestHandler, String requestIdHeaderName, RequestCorrelator correlator) {
        HttpRequestIdProvider provider = new HttpRequestIdProvider(requestIdHeaderName, correlator);
        return RxContexts.newHttpServerBuilder(port, requestHandler, provider, correlator);
    }

    public static <I, O> HttpClientBuilder<I, O> newHttpClientBuilder(String host, int port, RequestCorrelator correlator) {
        HttpRequestIdProvider provider = new HttpRequestIdProvider(defaultRequestIdContextKeyName, correlator);
        return RxContexts.newHttpClientBuilder(host, port, provider, correlator);
    }

    public static <I, O> HttpClientBuilder<I, O> newHttpClientBuilder(String host, int port, RequestCorrelator correlator, PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> httpConfigurator) {
        HttpRequestIdProvider provider = new HttpRequestIdProvider(defaultRequestIdContextKeyName, correlator);
        return RxContexts.newHttpClientBuilder(host, port, provider, correlator, httpConfigurator);
    }

    public static <I, O> HttpClientBuilder<I, O> newHttpClientBuilder(String host, int port, String requestIdHeaderName, RequestCorrelator correlator) {
        HttpRequestIdProvider provider = new HttpRequestIdProvider(requestIdHeaderName, correlator);
        return RxContexts.newHttpClientBuilder(host, port, provider, correlator);
    }

    public static <I, O> HttpServerBuilder<I, O> newHttpServerBuilder(int port, RequestHandler<I, O> requestHandler, RequestIdProvider provider, RequestCorrelator correlator, PipelineConfigurator<HttpServerRequest<I>, HttpServerResponse<O>> configurator) {
        return (HttpServerBuilder)RxNetty.newHttpServerBuilder(port, requestHandler).pipelineConfigurator(ContextPipelineConfigurators.httpServerConfigurator(provider, correlator, configurator));
    }

    public static <I, O> HttpServerBuilder<I, O> newHttpServerBuilder(int port, RequestHandler<I, O> requestHandler, RequestIdProvider provider, RequestCorrelator correlator) {
        return (HttpServerBuilder)RxNetty.newHttpServerBuilder(port, requestHandler).pipelineConfigurator(ContextPipelineConfigurators.httpServerConfigurator(provider, correlator));
    }

    public static <I, O> HttpClientBuilder<I, O> newHttpClientBuilder(String host, int port, RequestIdProvider provider, RequestCorrelator correlator) {
        HttpClientBuilder builder = RxNetty.newHttpClientBuilder(host, port);
        return (HttpClientBuilder)((HttpClientBuilder)builder.pipelineConfigurator(ContextPipelineConfigurators.httpClientConfigurator(provider, correlator))).withChannelFactory(new HttpContextClientChannelFactory(builder.getBootstrap(), correlator, builder.getEventsSubject()));
    }

    public static <I, O> HttpClientBuilder<I, O> newHttpClientBuilder(String host, int port, RequestIdProvider provider, RequestCorrelator correlator, PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> httpConfigurator) {
        HttpClientBuilder<HttpClientRequest<I>, HttpClientResponse<O>> builder = RxNetty.newHttpClientBuilder(host, port);
        return (HttpClientBuilder)((HttpClientBuilder)builder.pipelineConfigurator(ContextPipelineConfigurators.httpClientConfigurator(provider, correlator, httpConfigurator))).withChannelFactory(new HttpContextClientChannelFactory(builder.getBootstrap(), correlator, builder.getEventsSubject()));
    }

    public static HttpServer<ByteBuf, ByteBuf> createHttpServer(int port, RequestHandler<ByteBuf, ByteBuf> requestHandler) {
        return RxContexts.newHttpServerBuilder(port, requestHandler, defaultRequestIdContextKeyName, (RequestCorrelator)DEFAULT_CORRELATOR).build();
    }

    public static HttpServer<ByteBuf, ByteBuf> createHttpServer(int port, RequestHandler<ByteBuf, ByteBuf> requestHandler, String requestIdHeaderName) {
        return RxContexts.newHttpServerBuilder(port, requestHandler, requestIdHeaderName, (RequestCorrelator)DEFAULT_CORRELATOR).build();
    }

    public static HttpClient<ByteBuf, ByteBuf> createHttpClient(String host, int port) {
        return (HttpClient)RxContexts.newHttpClientBuilder(host, port, defaultRequestIdContextKeyName, (RequestCorrelator)DEFAULT_CORRELATOR).build();
    }

    public static HttpClient<ByteBuf, ByteBuf> createHttpClient(String host, int port, String requestIdHeaderName) {
        return (HttpClient)RxContexts.newHttpClientBuilder(host, port, requestIdHeaderName, (RequestCorrelator)DEFAULT_CORRELATOR).build();
    }

    public static <I, O> HttpServer<I, O> createHttpServer(int port, RequestHandler<I, O> requestHandler, PipelineConfigurator<HttpServerRequest<I>, HttpServerResponse<O>> configurator) {
        HttpRequestIdProvider provider = new HttpRequestIdProvider(defaultRequestIdContextKeyName, DEFAULT_CORRELATOR);
        return ((HttpServerBuilder)RxContexts.newHttpServerBuilder(port, requestHandler, defaultRequestIdContextKeyName, (RequestCorrelator)DEFAULT_CORRELATOR).pipelineConfigurator(ContextPipelineConfigurators.httpServerConfigurator(provider, DEFAULT_CORRELATOR, configurator))).build();
    }

    public static <I, O> HttpServer<I, O> createHttpServer(int port, RequestHandler<I, O> requestHandler, String requestIdHeaderName, PipelineConfigurator<HttpServerRequest<I>, HttpServerResponse<O>> configurator) {
        HttpRequestIdProvider provider = new HttpRequestIdProvider(requestIdHeaderName, DEFAULT_CORRELATOR);
        return ((HttpServerBuilder)RxContexts.newHttpServerBuilder(port, requestHandler, requestIdHeaderName, (RequestCorrelator)DEFAULT_CORRELATOR).pipelineConfigurator(ContextPipelineConfigurators.httpServerConfigurator(provider, DEFAULT_CORRELATOR, configurator))).build();
    }

    public static <I, O> HttpClient<I, O> createHttpClient(String host, int port, PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> configurator) {
        HttpRequestIdProvider provider = new HttpRequestIdProvider(defaultRequestIdContextKeyName, DEFAULT_CORRELATOR);
        return (HttpClient)((HttpClientBuilder)RxContexts.newHttpClientBuilder(host, port, defaultRequestIdContextKeyName, (RequestCorrelator)DEFAULT_CORRELATOR).pipelineConfigurator(ContextPipelineConfigurators.httpClientConfigurator(provider, DEFAULT_CORRELATOR, configurator))).build();
    }

    public static <I, O> HttpClient<I, O> createHttpClient(String host, int port, String requestIdHeaderName, PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> configurator) {
        HttpRequestIdProvider provider = new HttpRequestIdProvider(requestIdHeaderName, DEFAULT_CORRELATOR);
        return (HttpClient)((HttpClientBuilder)RxContexts.newHttpClientBuilder(host, port, requestIdHeaderName, (RequestCorrelator)DEFAULT_CORRELATOR).pipelineConfigurator(ContextPipelineConfigurators.httpClientConfigurator(provider, DEFAULT_CORRELATOR, configurator))).build();
    }

    public static void useRequestIdContextKey(String name) {
        defaultRequestIdContextKeyName = name;
    }
}

