/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.results;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.AggregatorUtils;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.util.ListStatistics;
import org.openjdk.jmh.util.Statistics;

public class AverageTimeResult
extends Result {
    public AverageTimeResult(ResultRole mode, String label, long operations, long durationNs, TimeUnit tu) {
        this(mode, label, AverageTimeResult.of(1.0 * (double)durationNs / (double)(operations * TimeUnit.NANOSECONDS.convert(1L, tu))), TimeValue.tuToString(tu) + "/op");
    }

    AverageTimeResult(ResultRole mode, String label, Statistics value, String unit) {
        super(mode, label, value, unit, AggregationPolicy.AVG);
    }

    protected Aggregator<AverageTimeResult> getThreadAggregator() {
        return new ResultAggregator();
    }

    protected Aggregator<AverageTimeResult> getIterationAggregator() {
        return new ResultAggregator();
    }

    static class ResultAggregator
    implements Aggregator<AverageTimeResult> {
        ResultAggregator() {
        }

        public AverageTimeResult aggregate(Collection<AverageTimeResult> results) {
            ListStatistics stat = new ListStatistics();
            for (AverageTimeResult r : results) {
                stat.addValue(r.getScore());
            }
            return new AverageTimeResult(AggregatorUtils.aggregateRoles(results), AggregatorUtils.aggregateLabels(results), stat, AggregatorUtils.aggregateUnits(results));
        }
    }
}

