/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Func0;
import rx.functions.Func2;

public final class OperatorScan<R, T>
implements Observable.Operator<R, T> {
    private final Func0<R> initialValueFactory;
    private final Func2<R, ? super T, R> accumulator;
    private static final Object NO_INITIAL_VALUE = new Object();

    public OperatorScan(final R initialValue, Func2<R, ? super T, R> accumulator) {
        this(new Func0<R>(){

            @Override
            public R call() {
                return initialValue;
            }
        }, accumulator);
    }

    public OperatorScan(Func0<R> initialValueFactory, Func2<R, ? super T, R> accumulator) {
        this.initialValueFactory = initialValueFactory;
        this.accumulator = accumulator;
    }

    public OperatorScan(Func2<R, ? super T, R> accumulator) {
        this(NO_INITIAL_VALUE, accumulator);
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super R> child) {
        return new Subscriber<T>(child){
            private final R initialValue;
            private R value;
            boolean initialized;
            {
                super(op);
                this.initialValue = OperatorScan.this.initialValueFactory.call();
                this.value = this.initialValue;
                this.initialized = false;
            }

            @Override
            public void onNext(T currentValue) {
                this.emitInitialValueIfNeeded(child);
                if (this.value == NO_INITIAL_VALUE) {
                    this.value = currentValue;
                } else {
                    try {
                        this.value = OperatorScan.this.accumulator.call(this.value, currentValue);
                    }
                    catch (Throwable e) {
                        child.onError(OnErrorThrowable.addValueAsLastCause(e, currentValue));
                    }
                }
                child.onNext(this.value);
            }

            @Override
            public void onError(Throwable e) {
                child.onError(e);
            }

            @Override
            public void onCompleted() {
                this.emitInitialValueIfNeeded(child);
                child.onCompleted();
            }

            private void emitInitialValueIfNeeded(Subscriber<? super R> child2) {
                if (!this.initialized) {
                    this.initialized = true;
                    if (this.initialValue != NO_INITIAL_VALUE) {
                        child2.onNext(this.initialValue);
                    }
                }
            }

            @Override
            public void setProducer(final Producer producer) {
                child.setProducer(new Producer(){
                    final AtomicBoolean once = new AtomicBoolean();
                    final AtomicBoolean excessive = new AtomicBoolean();

                    @Override
                    public void request(long n) {
                        if (this.once.compareAndSet(false, true)) {
                            if (initialValue == NO_INITIAL_VALUE || n == Long.MAX_VALUE) {
                                producer.request(n);
                            } else if (n == 1L) {
                                this.excessive.set(true);
                                producer.request(1L);
                            } else {
                                producer.request(n - 1L);
                            }
                        } else if (n > 1L && this.excessive.compareAndSet(true, false) && n != Long.MAX_VALUE) {
                            producer.request(n - 1L);
                        } else {
                            producer.request(n);
                        }
                    }
                });
            }
        };
    }
}

