/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.util.FileUtils;
import org.openjdk.jmh.util.InputStreamDrainer;
import org.openjdk.jmh.util.Multiset;
import org.openjdk.jmh.util.TreeMultiset;
import org.openjdk.jmh.util.Utils;

public class LinuxPerfAsmProfiler
implements ExternalProfiler {
    private static final String[] EVENTS = new String[]{"cycles", "instructions"};
    private static final String[] EVENTS_SHORT = new String[]{"clk", "insn"};
    private String perfBinData = FileUtils.tempFile("perfbin").getAbsolutePath();
    private String perfParsedData = FileUtils.tempFile("perfparsed").getAbsolutePath();
    private boolean useDelay;

    @Override
    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        long delay = TimeUnit.NANOSECONDS.toMillis((long)params.getWarmup().getCount() * params.getWarmup().getTime().convertTo(TimeUnit.NANOSECONDS) + 1000L);
        if (this.useDelay) {
            return Arrays.asList("perf", "record", "-c 100000", "-e " + Utils.join(EVENTS, ","), "-o" + this.perfBinData, "-D " + delay);
        }
        return Arrays.asList("perf", "record", "-c 100000", "-e " + Utils.join(EVENTS, ","), "-o" + this.perfBinData);
    }

    @Override
    public Collection<String> addJVMOptions(BenchmarkParams params) {
        return Arrays.asList("-XX:+UnlockDiagnosticVMOptions", "-XX:+PrintAssembly");
    }

    @Override
    public void beforeTrial(BenchmarkParams params) {
    }

    @Override
    public Collection<? extends Result> afterTrial(BenchmarkParams params, File stdOut, File stdErr) {
        PerfResult result = this.processAssembly(stdOut, stdErr);
        return Collections.singleton(result);
    }

    @Override
    public Collection<String> checkSupport() {
        Collection<String> delay = this.tryWith("perf stat -D 1 echo 1");
        if (delay.isEmpty()) {
            this.useDelay = true;
            return delay;
        }
        return this.tryWith("perf stat echo 1");
    }

    public Collection<String> tryWith(String cmd) {
        ArrayList<String> messages = new ArrayList<String>();
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStreamDrainer errDrainer = new InputStreamDrainer(p.getErrorStream(), baos);
            InputStreamDrainer outDrainer = new InputStreamDrainer(p.getInputStream(), baos);
            errDrainer.start();
            outDrainer.start();
            int err = p.waitFor();
            errDrainer.join();
            outDrainer.join();
            if (err > 0) {
                messages.add(baos.toString());
            }
        }
        catch (IOException ex) {
            return Collections.singleton(ex.getMessage());
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
        return messages;
    }

    @Override
    public String label() {
        return "perfasm";
    }

    @Override
    public String getDescription() {
        return "Linux perf + PrintAssembly Profiler";
    }

    private PerfResult processAssembly(File stdOut, File stdErr) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            Process p = Runtime.getRuntime().exec("perf script -i " + this.perfBinData);
            FileOutputStream fos = new FileOutputStream(this.perfParsedData);
            InputStreamDrainer errDrainer = new InputStreamDrainer(p.getErrorStream(), fos);
            InputStreamDrainer outDrainer = new InputStreamDrainer(p.getInputStream(), fos);
            errDrainer.start();
            outDrainer.start();
            p.waitFor();
            errDrainer.join();
            outDrainer.join();
            fos.flush();
            fos.close();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
        try {
            String line;
            FileInputStream fis = new FileInputStream(this.perfParsedData);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
            TreeMap events = new TreeMap();
            TreeMultiset<Long> eventAddrs = new TreeMultiset<Long>();
            while ((line = reader.readLine()) != null) {
                String[] elements;
                if (line.startsWith("#") || !(elements = (line = line.trim()).split("[ ]+"))[0].equalsIgnoreCase("java")) continue;
                String evName = elements[3].replace(":", "");
                TreeMultiset<Long> evs = (TreeMultiset<Long>)events.get(evName);
                if (evs == null) {
                    evs = new TreeMultiset<Long>();
                    events.put(evName, evs);
                }
                try {
                    Long element = Long.valueOf(elements[4], 16);
                    evs.add(element);
                    eventAddrs.add(element);
                }
                catch (NumberFormatException e) {}
            }
            int CONTEXT_BUFFER = 10;
            double FILTER_THRESHOLD = 0.001;
            long sum = 0L;
            Iterator i$ = eventAddrs.keys().iterator();
            while (i$.hasNext()) {
                long a = (Long)i$.next();
                sum += (long)eventAddrs.count(a);
            }
            int THRESHOLD = (int)((double)sum * 0.001);
            ArrayDeque<String> buffer = new ArrayDeque<String>(10);
            int linesToPrint = 0;
            HashMap<String, Integer> sizes = new HashMap<String, Integer>();
            for (String eventType : EVENTS) {
                sizes.put(eventType, ((Multiset)events.get(eventType)).size());
            }
            BufferedReader br = new BufferedReader(new FileReader(stdOut));
            while ((line = br.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                String[] elements = line.trim().split(" ");
                String bufferedLine = "";
                boolean eventsPrinted = false;
                if (elements.length >= 1) {
                    try {
                        Long addr = Long.valueOf(elements[0].replace("0x", "").replace(":", ""), 16);
                        int eventCount = eventAddrs.count(addr);
                        if (eventCount > 0) {
                            for (String eventType : EVENTS) {
                                int count = ((Multiset)events.get(eventType)).count(addr);
                                bufferedLine = bufferedLine + String.format("%5.2f%% ", 100.0 * (double)count / (double)((Integer)sizes.get(eventType)).intValue());
                            }
                            eventsPrinted = true;
                        }
                        if (eventCount > THRESHOLD) {
                            for (String bl : buffer) {
                                pw.println(bl);
                            }
                            buffer.clear();
                            linesToPrint = 10;
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (!eventsPrinted) {
                    for (String eventType : EVENTS) {
                        bufferedLine = bufferedLine + String.format("%6s ", "");
                    }
                }
                bufferedLine = bufferedLine + line;
                if (--linesToPrint >= 0) {
                    pw.println(bufferedLine);
                    if (linesToPrint != 0) continue;
                    pw.println("---------------------------------------------------------------------------------");
                    for (String eventType : EVENTS_SHORT) {
                        pw.print(String.format("%6s ", eventType));
                    }
                    pw.println();
                    pw.println();
                    continue;
                }
                buffer.add(bufferedLine);
                if (buffer.size() <= 10) continue;
                buffer.pollFirst();
            }
            pw.println();
            String hot = sw.toString();
            if (hot.trim().isEmpty()) {
                return new PerfResult("No assembly, make sure your JDK is PrintAssembly-enabled:\n    https://wikis.oracle.com/display/HotSpotInternals/PrintAssembly");
            }
            String header = "Hottest generated code regions:\n";
            header = header + "(values do not normally add up to 100%, the remaining parts are dispersed\n";
            header = header + " across other warm generated code blocks, and VM native code itself; use\n";
            header = header + " full-fledged profilers to get a cleaner picture)\n";
            header = header + "---------------------------------------------------------------------------------\n";
            for (String eventType : EVENTS_SHORT) {
                header = header + String.format("%6s ", eventType);
            }
            header = header + "\n";
            hot = header + hot;
            return new PerfResult(hot);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    static class PerfResultAggregator
    implements Aggregator<PerfResult> {
        PerfResultAggregator() {
        }

        @Override
        public Result aggregate(Collection<PerfResult> results) {
            String output = "";
            for (PerfResult r : results) {
                output = output + r.output;
            }
            return new PerfResult(output);
        }
    }

    static class PerfResult
    extends Result<PerfResult> {
        private final String output;

        public PerfResult(String output) {
            super(ResultRole.SECONDARY, "@asm", PerfResult.of(Double.NaN), "N/A", AggregationPolicy.AVG);
            this.output = output;
        }

        @Override
        protected Aggregator<PerfResult> getThreadAggregator() {
            return new PerfResultAggregator();
        }

        @Override
        protected Aggregator<PerfResult> getIterationAggregator() {
            return new PerfResultAggregator();
        }

        @Override
        public String toString() {
            return "(text only)";
        }

        @Override
        public String extendedInfo(String label) {
            return this.output;
        }
    }
}

