/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.core;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.openjdk.jmh.annotations.AuxCounters;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.generators.core.BenchmarkGeneratorUtils;
import org.openjdk.jmh.generators.core.ClassInfo;
import org.openjdk.jmh.generators.core.CompilerControlPlugin;
import org.openjdk.jmh.generators.core.FieldInfo;
import org.openjdk.jmh.generators.core.GenerationException;
import org.openjdk.jmh.generators.core.HelperMethodInvocation;
import org.openjdk.jmh.generators.core.HelperType;
import org.openjdk.jmh.generators.core.Identifiers;
import org.openjdk.jmh.generators.core.MethodGroup;
import org.openjdk.jmh.generators.core.MethodInfo;
import org.openjdk.jmh.generators.core.ParameterInfo;
import org.openjdk.jmh.generators.core.StateObject;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.Control;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.infra.ThreadParams;
import org.openjdk.jmh.util.HashMultimap;
import org.openjdk.jmh.util.Multimap;

class StateObjectHandler {
    private final CompilerControlPlugin compileControl;
    private final Identifiers identifiers;
    private final Multimap<String, StateObject> args;
    private final Multimap<String, StateObject> stateHelperArgs;
    private final Multimap<StateObject, StateObject> stateObjectDeps;
    private final Map<String, StateObject> implicits;
    private final Set<StateObject> stateObjects;
    private final Multimap<String, String> auxNames = new HashMultimap<String, String>();
    private final Map<String, String> auxAccessors = new HashMap<String, String>();

    public StateObjectHandler(CompilerControlPlugin compileControl) {
        this.compileControl = compileControl;
        this.args = new HashMultimap<String, StateObject>();
        this.implicits = new HashMap<String, StateObject>();
        this.stateObjects = new HashSet<StateObject>();
        this.stateHelperArgs = new HashMultimap<String, StateObject>();
        this.stateObjectDeps = new HashMultimap<StateObject, StateObject>();
        this.identifiers = new Identifiers();
    }

    public State getState(ClassInfo ci, ParameterInfo pi) {
        State ann = BenchmarkGeneratorUtils.getAnnSuper(ci, State.class);
        if (ann == null) {
            throw new GenerationException("The method parameter is not a @" + State.class.getSimpleName() + ": ", pi);
        }
        return ann;
    }

    public void bindMethodGroup(MethodGroup mg) {
        for (MethodInfo method : mg.methods()) {
            HashSet<StateObject> seen = new HashSet<StateObject>();
            for (ParameterInfo ppi : method.getParameters()) {
                ClassInfo pci = ppi.getType();
                StateObject pso = new StateObject(this.identifiers, pci.getQualifiedName(), this.getState(pci, ppi).value());
                this.stateObjects.add(pso);
                this.args.put(method.getName(), pso);
                this.bindState(method, pso, pci);
                seen.add(pso);
                this.recursiveStateResolve(method, pci, pso, seen);
            }
        }
    }

    private void recursiveStateResolve(MethodInfo method, ClassInfo pci, StateObject pso, Set<StateObject> seen) {
        for (MethodInfo mi : BenchmarkGeneratorUtils.getMethods(pci)) {
            if (mi.getAnnotation(Setup.class) == null && mi.getAnnotation(TearDown.class) == null) continue;
            for (ParameterInfo pi : mi.getParameters()) {
                ClassInfo ci = pi.getType();
                StateObject so = new StateObject(this.identifiers, ci.getQualifiedName(), this.getState(ci, pi).value());
                if (!seen.add(so)) {
                    throw new GenerationException("@" + State.class.getSimpleName() + " dependency cycle is detected.", pi);
                }
                if (this.stateHelperArgs.get(mi.getQualifiedName()).contains(so)) continue;
                this.stateObjects.add(so);
                this.stateObjectDeps.put(pso, so);
                this.stateHelperArgs.put(mi.getQualifiedName(), so);
                this.bindState(method, so, ci);
                this.recursiveStateResolve(method, ci, so, seen);
            }
        }
    }

    public void bindImplicit(ClassInfo ci, String label, Scope scope) {
        State ann = BenchmarkGeneratorUtils.getAnnSuper(ci, State.class);
        StateObject so = new StateObject(this.identifiers, ci.getQualifiedName(), ann != null ? ann.value() : scope);
        this.stateObjects.add(so);
        this.implicits.put(label, so);
        this.bindState(null, so, ci);
        HashSet<StateObject> seen = new HashSet<StateObject>();
        this.recursiveStateResolve(null, ci, so, seen);
    }

    private void bindState(MethodInfo execMethod, StateObject so, ClassInfo ci) {
        if (ci.getAnnotation(AuxCounters.class) != null) {
            String prev;
            String meth;
            String name;
            if (so.scope != Scope.Thread) {
                throw new GenerationException("@" + AuxCounters.class.getSimpleName() + " can only be used with " + Scope.class.getSimpleName() + "." + (Object)((Object)Scope.Thread) + " states.", ci);
            }
            for (FieldInfo fieldInfo : ci.getFields()) {
                String fieldType;
                if (!fieldInfo.isPublic() || !(fieldType = fieldInfo.getType().getQualifiedName()).equals("int") && !fieldType.equals("long")) continue;
                name = fieldInfo.getName();
                meth = execMethod.getName();
                this.auxNames.put(meth, name);
                prev = this.auxAccessors.put(meth + name, so.localIdentifier + "." + name);
                if (prev == null) continue;
                throw new GenerationException("Conflicting @" + AuxCounters.class.getSimpleName() + " counters. Make sure there are no @" + State.class.getSimpleName() + "-s with the same counter " + " injected into this method.", fieldInfo);
            }
            for (MethodInfo methodInfo : ci.getMethods()) {
                String returnType;
                if (!methodInfo.isPublic() || !(returnType = methodInfo.getReturnType()).equals("int") && !returnType.equals("long")) continue;
                name = methodInfo.getName();
                meth = execMethod.getName();
                this.auxNames.put(meth, name);
                prev = this.auxAccessors.put(meth + name, so.localIdentifier + "." + name + "()");
                if (prev == null) continue;
                throw new GenerationException("Conflicting @" + AuxCounters.class.getSimpleName() + " counters. Make sure there are no @" + State.class.getSimpleName() + "-s with the same counter " + " injected into this method.", methodInfo);
            }
        }
        for (FieldInfo fieldInfo : BenchmarkGeneratorUtils.getAllFields(ci)) {
            if (fieldInfo.getAnnotation(Param.class) == null) continue;
            this.checkParam(fieldInfo);
            so.addParam(fieldInfo);
        }
        for (MethodInfo methodInfo : BenchmarkGeneratorUtils.getMethods(ci)) {
            TearDown tearDownAnn;
            Setup setupAnn = methodInfo.getAnnotation(Setup.class);
            if (setupAnn != null) {
                this.checkHelpers(methodInfo, Setup.class);
                so.addHelper(new HelperMethodInvocation(methodInfo, so, setupAnn.value(), HelperType.SETUP));
                this.compileControl.defaultForceInline(methodInfo);
            }
            if ((tearDownAnn = methodInfo.getAnnotation(TearDown.class)) == null) continue;
            this.checkHelpers(methodInfo, TearDown.class);
            so.addHelper(new HelperMethodInvocation(methodInfo, so, tearDownAnn.value(), HelperType.TEARDOWN));
            this.compileControl.defaultForceInline(methodInfo);
        }
    }

    private void checkParam(FieldInfo fi) {
        if (fi.isStatic()) {
            throw new GenerationException("@" + Param.class.getSimpleName() + " annotation is not acceptable on static fields.", fi);
        }
        if (BenchmarkGeneratorUtils.getAnnSyntax(fi.getDeclaringClass(), State.class) == null) {
            throw new GenerationException("@" + Param.class.getSimpleName() + " annotation should be placed in @" + State.class.getSimpleName() + "-annotated class.", fi);
        }
        ClassInfo type = fi.getType();
        if (!this.isParamTypeAcceptable(type)) {
            throw new GenerationException("@" + Param.class.getSimpleName() + " can only be placed over the annotation-compatible types:" + " primitives, primitive wrappers, Strings, or enums.", fi);
        }
        String[] values = fi.getAnnotation(Param.class).value();
        if (values.length == 1 && values[0].equalsIgnoreCase("blank_blank_blank_2014")) {
            if (!fi.getType().isEnum()) {
                throw new GenerationException("@" + Param.class.getSimpleName() + " should provide the default parameters.", fi);
            }
        } else {
            for (String val : values) {
                if (this.isParamValueConforming(fi, val, type)) continue;
                throw new GenerationException("Some @" + Param.class.getSimpleName() + " values can not be converted to target type: " + "\"" + val + "\" can not be converted to " + type, fi);
            }
        }
    }

    private boolean isParamTypeAcceptable(ClassInfo type) {
        String typeName = type.getQualifiedName();
        if (type.isEnum()) {
            return true;
        }
        if (typeName.equals("java.lang.String")) {
            return true;
        }
        if (typeName.equals("boolean") || typeName.equals("java.lang.Boolean")) {
            return true;
        }
        if (typeName.equals("byte") || typeName.equals("java.lang.Byte")) {
            return true;
        }
        if (typeName.equals("char") || typeName.equals("java.lang.Character")) {
            return true;
        }
        if (typeName.equals("short") || typeName.equals("java.lang.Short")) {
            return true;
        }
        if (typeName.equals("int") || typeName.equals("java.lang.Integer")) {
            return true;
        }
        if (typeName.equals("float") || typeName.equals("java.lang.Float")) {
            return true;
        }
        if (typeName.equals("long") || typeName.equals("java.lang.Long")) {
            return true;
        }
        return typeName.equals("double") || typeName.equals("java.lang.Double");
    }

    private boolean isParamValueConforming(FieldInfo fi, String val, ClassInfo type) {
        String typeName = type.getQualifiedName();
        if (type.isEnum() && type.getEnumConstants().contains(val)) {
            return true;
        }
        if (typeName.equals("java.lang.String")) {
            return true;
        }
        if (typeName.equals("boolean") || typeName.equals("java.lang.Boolean")) {
            return val.equals("true") || val.equals("false");
        }
        if (typeName.equals("byte") || typeName.equals("java.lang.Byte")) {
            try {
                Byte.valueOf(val);
                return true;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (typeName.equals("char") || typeName.equals("java.lang.Character")) {
            return val.length() == 1;
        }
        if (typeName.equals("short") || typeName.equals("java.lang.Short")) {
            try {
                Short.valueOf(val);
                return true;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (typeName.equals("int") || typeName.equals("java.lang.Integer")) {
            try {
                Integer.valueOf(val);
                return true;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (typeName.equals("float") || typeName.equals("java.lang.Float")) {
            try {
                Float.valueOf(val);
                return true;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (typeName.equals("long") || typeName.equals("java.lang.Long")) {
            try {
                Long.valueOf(val);
                return true;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (typeName.equals("double") || typeName.equals("java.lang.Double")) {
            try {
                Double.valueOf(val);
                return true;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return false;
    }

    private void checkHelpers(MethodInfo mi, Class<? extends Annotation> annClass) {
        if (BenchmarkGeneratorUtils.getAnnSuper(mi.getDeclaringClass(), State.class) == null && !mi.getDeclaringClass().isAbstract()) {
            throw new GenerationException("@" + TearDown.class.getSimpleName() + " annotation is placed within " + "the class not having @" + State.class.getSimpleName() + " annotation. " + "This has no behavioral effect, and prohibited.", mi);
        }
        if (!mi.isPublic()) {
            throw new GenerationException("@" + annClass.getSimpleName() + " method should be public.", mi);
        }
        if (!mi.getReturnType().equalsIgnoreCase("void")) {
            throw new GenerationException("@" + annClass.getSimpleName() + " method should not return anything.", mi);
        }
    }

    public String getGMBArgList(MethodInfo methodInfo) {
        return this.getArgList(this.args.get(methodInfo.getName()));
    }

    public String getArgList(MethodInfo methodInfo) {
        return this.getArgList(this.stateOrder(methodInfo, false));
    }

    public String getArgList(Collection<StateObject> sos) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (StateObject so : sos) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(so.toLocal());
            ++i;
        }
        return sb.toString();
    }

    public String getTypeArgList(MethodInfo methodInfo) {
        return this.getTypeArgList(this.stateOrder(methodInfo, false));
    }

    public String getTypeArgList(Collection<StateObject> sos) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (StateObject so : sos) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(so.toTypeDef());
            ++i;
        }
        return sb.toString();
    }

    public static Collection<StateObject> cons(Collection<StateObject> ... colls) {
        TreeSet<StateObject> r = new TreeSet<StateObject>(StateObject.ID_COMPARATOR);
        for (Collection<StateObject> coll : colls) {
            r.addAll(coll);
        }
        return r;
    }

    public Collection<String> getHelperBlock(MethodInfo method, Level helperLevel, HelperType type) {
        Collection<StateObject> args;
        ArrayList<StateObject> statesForward = new ArrayList<StateObject>();
        for (StateObject so : this.stateOrder(method, true)) {
            for (HelperMethodInvocation hmi : so.getHelpers()) {
                if (hmi.helperLevel != helperLevel) continue;
                statesForward.add(so);
            }
        }
        ArrayList<StateObject> statesReverse = new ArrayList<StateObject>();
        for (StateObject so : this.stateOrder(method, false)) {
            for (HelperMethodInvocation hmi : so.getHelpers()) {
                if (hmi.helperLevel != helperLevel) continue;
                statesReverse.add(so);
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        for (StateObject so : statesForward) {
            if (so.scope != Scope.Thread || type != HelperType.SETUP) continue;
            result.add("if (!" + so.localIdentifier + ".ready" + (Object)((Object)helperLevel) + ") {");
            for (HelperMethodInvocation mi : so.getHelpers()) {
                if (mi.helperLevel != helperLevel || mi.type != HelperType.SETUP) continue;
                args = this.stateHelperArgs.get(mi.method.getQualifiedName());
                result.add("    " + so.localIdentifier + "." + mi.method.getName() + "(" + this.getArgList(args) + ");");
            }
            result.add("    " + so.localIdentifier + ".ready" + (Object)((Object)helperLevel) + " = true;");
            result.add("}");
        }
        for (StateObject so : statesReverse) {
            if (so.scope != Scope.Thread || type != HelperType.TEARDOWN) continue;
            result.add("if (" + so.localIdentifier + ".ready" + (Object)((Object)helperLevel) + ") {");
            for (HelperMethodInvocation mi : so.getHelpers()) {
                if (mi.helperLevel != helperLevel || mi.type != HelperType.TEARDOWN) continue;
                args = this.stateHelperArgs.get(mi.method.getQualifiedName());
                result.add("    " + so.localIdentifier + "." + mi.method.getName() + "(" + this.getArgList(args) + ");");
            }
            result.add("    " + so.localIdentifier + ".ready" + (Object)((Object)helperLevel) + " = false;");
            result.add("}");
        }
        for (StateObject so : statesForward) {
            if (so.scope != Scope.Benchmark && so.scope != Scope.Group || type != HelperType.SETUP) continue;
            result.add("while(!" + so.type + ".setup" + (Object)((Object)helperLevel) + "MutexUpdater.compareAndSet(" + so.localIdentifier + ", 0, 1)) {");
            result.add("    if (Thread.interrupted()) throw new InterruptedException();");
            result.add("}");
            result.add("try {");
            result.add("    if (!" + so.localIdentifier + ".ready" + (Object)((Object)helperLevel) + ") {");
            for (HelperMethodInvocation mi : so.getHelpers()) {
                if (mi.helperLevel != helperLevel || mi.type != HelperType.SETUP) continue;
                args = this.stateHelperArgs.get(mi.method.getQualifiedName());
                result.add("        " + so.localIdentifier + "." + mi.method.getName() + "(" + this.getArgList(args) + ");");
            }
            result.add("        " + so.localIdentifier + ".ready" + (Object)((Object)helperLevel) + " = true;");
            result.add("    }");
            result.add("} finally {");
            result.add("    " + so.type + ".setup" + (Object)((Object)helperLevel) + "MutexUpdater.set(" + so.localIdentifier + ", 0);");
            result.add("}");
        }
        for (StateObject so : statesReverse) {
            if (so.scope != Scope.Benchmark && so.scope != Scope.Group || type != HelperType.TEARDOWN) continue;
            result.add("while(!" + so.type + ".tear" + (Object)((Object)helperLevel) + "MutexUpdater.compareAndSet(" + so.localIdentifier + ", 0, 1)) {");
            result.add("    if (Thread.interrupted()) throw new InterruptedException();");
            result.add("}");
            result.add("try {");
            result.add("    if (" + so.localIdentifier + ".ready" + (Object)((Object)helperLevel) + ") {");
            for (HelperMethodInvocation mi : so.getHelpers()) {
                if (mi.helperLevel != helperLevel || mi.type != HelperType.TEARDOWN) continue;
                args = this.stateHelperArgs.get(mi.method.getQualifiedName());
                result.add("        " + so.localIdentifier + "." + mi.method.getName() + "(" + this.getArgList(args) + ");");
            }
            result.add("        " + so.localIdentifier + ".ready" + (Object)((Object)helperLevel) + " = false;");
            result.add("    }");
            result.add("} finally {");
            result.add("    " + so.type + ".tear" + (Object)((Object)helperLevel) + "MutexUpdater.set(" + so.localIdentifier + ", 0);");
            result.add("}");
        }
        return result;
    }

    public Collection<String> getInvocationSetups(MethodInfo method) {
        return this.getHelperBlock(method, Level.Invocation, HelperType.SETUP);
    }

    public Collection<String> getInvocationTearDowns(MethodInfo method) {
        return this.getHelperBlock(method, Level.Invocation, HelperType.TEARDOWN);
    }

    public Collection<String> getIterationSetups(MethodInfo method) {
        return this.getHelperBlock(method, Level.Iteration, HelperType.SETUP);
    }

    public Collection<String> getIterationTearDowns(MethodInfo method) {
        return this.getHelperBlock(method, Level.Iteration, HelperType.TEARDOWN);
    }

    public Collection<String> getRunSetups(MethodInfo method) {
        return this.getHelperBlock(method, Level.Trial, HelperType.SETUP);
    }

    public Collection<String> getRunTearDowns(MethodInfo method) {
        return this.getHelperBlock(method, Level.Trial, HelperType.TEARDOWN);
    }

    public List<String> getStateInitializers() {
        Collection<StateObject> args;
        Collection<StateObject> sos = StateObjectHandler.cons(this.stateObjects);
        ArrayList<String> result = new ArrayList<String>();
        for (StateObject so : sos) {
            if (so.scope != Scope.Benchmark) continue;
            result.add("");
            result.add("static volatile " + so.type + " " + so.fieldIdentifier + ";");
            result.add("");
            result.add(so.type + " _jmh_tryInit_" + so.fieldIdentifier + "(InfraControl control, ThreadParams threadParams" + this.soDependency_TypeArgs(so) + ") throws Throwable {");
            result.add("    synchronized(this.getClass()) {");
            result.add("        if (" + so.fieldIdentifier + " == null) {");
            result.add("            " + so.fieldIdentifier + " = new " + so.type + "();");
            result.add("        }");
            result.add("        if (!" + so.fieldIdentifier + ".ready" + (Object)((Object)Level.Trial) + ") {");
            if (!so.getParamsLabels().isEmpty()) {
                result.add("            Field f;");
            }
            for (String paramName : so.getParamsLabels()) {
                result.add("            f = " + so.getParam(paramName).getDeclaringClass().getQualifiedName() + ".class.getDeclaredField(\"" + paramName + "\");");
                result.add("            f.setAccessible(true);");
                result.add("            f.set(" + so.fieldIdentifier + ", " + so.getParamAccessor(paramName) + ");");
            }
            for (HelperMethodInvocation hmi : so.getHelpers()) {
                if (hmi.helperLevel != Level.Trial || hmi.type != HelperType.SETUP) continue;
                args = this.stateHelperArgs.get(hmi.method.getQualifiedName());
                result.add("            " + so.fieldIdentifier + "." + hmi.method.getName() + "(" + this.getArgList(args) + ");");
            }
            result.add("            " + so.fieldIdentifier + ".ready" + (Object)((Object)Level.Trial) + " = true;");
            result.add("        }");
            result.add("    }");
            result.add("    return " + so.fieldIdentifier + ";");
            result.add("}");
        }
        for (StateObject so : sos) {
            if (so.scope != Scope.Thread) continue;
            result.add("");
            result.add(so.type + " " + so.fieldIdentifier + ";");
            result.add("");
            result.add(so.type + " _jmh_tryInit_" + so.fieldIdentifier + "(InfraControl control, ThreadParams threadParams" + this.soDependency_TypeArgs(so) + ") throws Throwable {");
            if (so.userType.equals(BenchmarkParams.class.getCanonicalName())) {
                result.add("    if (true) {");
                result.add("        " + so.type + " val = new " + so.type + "(control.benchmarkParams);");
            } else if (so.userType.equals(IterationParams.class.getCanonicalName())) {
                result.add("    if (true) {");
                result.add("        " + so.type + " val = new " + so.type + "(control.iterationParams);");
            } else if (so.userType.equals(ThreadParams.class.getCanonicalName())) {
                result.add("    if (true) {");
                result.add("        " + so.type + " val = new " + so.type + "(threadParams);");
            } else {
                result.add("    if (" + so.fieldIdentifier + " == null) {");
                result.add("        " + so.type + " val = new " + so.type + "();");
            }
            if (!so.getParamsLabels().isEmpty()) {
                result.add("            Field f;");
            }
            for (String paramName : so.getParamsLabels()) {
                result.add("        f = " + so.getParam(paramName).getDeclaringClass().getQualifiedName() + ".class.getDeclaredField(\"" + paramName + "\");");
                result.add("        f.setAccessible(true);");
                result.add("        f.set(val, " + so.getParamAccessor(paramName) + ");");
            }
            for (HelperMethodInvocation hmi : so.getHelpers()) {
                if (hmi.helperLevel != Level.Trial || hmi.type != HelperType.SETUP) continue;
                args = this.stateHelperArgs.get(hmi.method.getQualifiedName());
                result.add("        val." + hmi.method.getName() + "(" + this.getArgList(args) + ");");
            }
            result.add("        val.ready" + (Object)((Object)Level.Trial) + " = true;");
            result.add("        " + so.fieldIdentifier + " = val;");
            result.add("    }");
            result.add("    return " + so.fieldIdentifier + ";");
            result.add("}");
        }
        for (StateObject so : sos) {
            if (so.scope != Scope.Group) continue;
            result.add("");
            result.add("static java.util.Map<Integer, " + so.type + "> " + so.fieldIdentifier + "_map = java.util.Collections.synchronizedMap(new java.util.HashMap<Integer, " + so.type + ">());");
            result.add("");
            result.add(so.type + " _jmh_tryInit_" + so.fieldIdentifier + "(InfraControl control, ThreadParams threadParams" + this.soDependency_TypeArgs(so) + ") throws Throwable {");
            result.add("    synchronized(this.getClass()) {");
            result.add("        " + so.type + " local = " + so.fieldIdentifier + "_map.get(threadParams.getGroupIndex());");
            result.add("        if (local == null) {");
            result.add("            " + so.type + " val = new " + so.type + "();");
            result.add("            " + so.fieldIdentifier + "_map.put(threadParams.getGroupIndex(), val);");
            result.add("            local = val;");
            result.add("        }");
            result.add("        if (!local.ready" + (Object)((Object)Level.Trial) + ") {");
            if (!so.getParamsLabels().isEmpty()) {
                result.add("            Field f;");
            }
            for (String paramName : so.getParamsLabels()) {
                result.add("            f = " + so.getParam(paramName).getDeclaringClass().getQualifiedName() + ".class.getDeclaredField(\"" + paramName + "\");");
                result.add("            f.setAccessible(true);");
                result.add("            f.set(local, " + so.getParamAccessor(paramName) + ");");
            }
            for (HelperMethodInvocation hmi : so.getHelpers()) {
                if (hmi.helperLevel != Level.Trial || hmi.type != HelperType.SETUP) continue;
                args = this.stateHelperArgs.get(hmi.method.getQualifiedName());
                result.add("            local." + hmi.method.getName() + "(" + this.getArgList(args) + ");");
            }
            result.add("            local.ready" + (Object)((Object)Level.Trial) + " = true;");
            result.add("        }");
            result.add("        return local;");
            result.add("    }");
            result.add("}");
        }
        return result;
    }

    private String soDependency_TypeArgs(StateObject so) {
        return this.stateObjectDeps.get(so).isEmpty() ? "" : ", " + this.getTypeArgList(this.stateObjectDeps.get(so));
    }

    private String soDependency_Args(StateObject so) {
        return this.stateObjectDeps.get(so).isEmpty() ? "" : ", " + this.getArgList(this.stateObjectDeps.get(so));
    }

    public Collection<String> getStateDestructors(MethodInfo method) {
        LinkedHashSet<StateObject> sos = this.stateOrder(method, false);
        ArrayList<String> result = new ArrayList<String>();
        for (StateObject so : sos) {
            if (so.scope != Scope.Benchmark) continue;
            result.add("synchronized(this.getClass()) {");
            result.add("    " + so.fieldIdentifier + " = null;");
            result.add("}");
        }
        for (StateObject so : sos) {
            if (so.scope != Scope.Thread) continue;
            result.add("" + so.fieldIdentifier + " = null;");
        }
        for (StateObject so : sos) {
            if (so.scope != Scope.Group) continue;
            result.add("synchronized(this.getClass()) {");
            result.add("    " + so.fieldIdentifier + "_map.remove(threadParams.getGroupIndex());");
            result.add("}");
        }
        return result;
    }

    public List<String> getStateGetters(MethodInfo method) {
        ArrayList<String> result = new ArrayList<String>();
        block4: for (StateObject so : this.stateOrder(method, true)) {
            switch (so.scope) {
                case Benchmark: 
                case Thread: {
                    result.add(so.type + " " + so.localIdentifier + " = _jmh_tryInit_" + so.fieldIdentifier + "(control, threadParams" + this.soDependency_Args(so) + ");");
                    continue block4;
                }
                case Group: {
                    result.add(so.type + " " + so.localIdentifier + " = _jmh_tryInit_" + so.fieldIdentifier + "(control, threadParams" + this.soDependency_Args(so) + ");");
                    continue block4;
                }
            }
            throw new IllegalStateException("Unhandled scope: " + (Object)((Object)so.scope));
        }
        return result;
    }

    private LinkedHashSet<StateObject> stateOrder(MethodInfo method, boolean reverse) {
        ArrayList linearOrder = new ArrayList();
        ArrayList<StateObject> stratum = new ArrayList<StateObject>();
        stratum.addAll(this.args.get(method.getName()));
        stratum.addAll(this.implicits.values());
        stratum.addAll(this.getControls());
        while (!stratum.isEmpty()) {
            linearOrder.addAll(stratum);
            ArrayList<StateObject> newStratum = new ArrayList<StateObject>();
            for (StateObject so : stratum) {
                newStratum.addAll(this.stateObjectDeps.get(so));
            }
            stratum = newStratum;
        }
        if (reverse) {
            Collections.reverse(linearOrder);
        }
        return new LinkedHashSet<StateObject>(linearOrder);
    }

    public void addSuperCall(List<String> result, StateObject so, String suffix) {
        if (so.userType.equals(BenchmarkParams.class.getCanonicalName()) || so.userType.equals(IterationParams.class.getCanonicalName()) || so.userType.equals(ThreadParams.class.getCanonicalName())) {
            result.add("    public " + so.type + suffix + "(" + so.userType + " other) {");
            result.add("        super(other);");
            result.add("    }");
        }
    }

    public List<String> getStateOverrides() {
        HashSet<String> visited = new HashSet<String>();
        ArrayList<String> result = new ArrayList<String>();
        for (StateObject so : StateObjectHandler.cons(this.stateObjects)) {
            if (!visited.add(so.userType)) continue;
            result.add("static class " + so.type + "_B1 extends " + so.userType + " {");
            StateObjectHandler.padding(result, "b1");
            this.addSuperCall(result, so, "_B1");
            result.add("}");
            result.add("");
            result.add("static class " + so.type + "_B2 extends " + so.type + "_B1 {");
            for (Level level : Level.values()) {
                result.add("    public volatile int setup" + (Object)((Object)level) + "Mutex;");
                result.add("    public volatile int tear" + (Object)((Object)level) + "Mutex;");
                result.add("    public final static AtomicIntegerFieldUpdater setup" + (Object)((Object)level) + "MutexUpdater = " + "AtomicIntegerFieldUpdater.newUpdater(" + so.type + "_B2.class, \"setup" + (Object)((Object)level) + "Mutex\");");
                result.add("    public final static AtomicIntegerFieldUpdater tear" + (Object)((Object)level) + "MutexUpdater = " + "AtomicIntegerFieldUpdater.newUpdater(" + so.type + "_B2.class, \"tear" + (Object)((Object)level) + "Mutex\");");
                result.add("");
            }
            switch (so.scope) {
                case Benchmark: 
                case Group: {
                    for (Level level : Level.values()) {
                        result.add("    public volatile boolean ready" + (Object)((Object)level) + ";");
                    }
                    break;
                }
                case Thread: {
                    for (Level level : Level.values()) {
                        result.add("    public boolean ready" + (Object)((Object)level) + ";");
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown state scope: " + (Object)((Object)so.scope));
                }
            }
            this.addSuperCall(result, so, "_B2");
            result.add("}");
            result.add("");
            result.add("static class " + so.type + "_B3 extends " + so.type + "_B2 {");
            StateObjectHandler.padding(result, "b3");
            this.addSuperCall(result, so, "_B3");
            result.add("}");
            result.add("");
            result.add("static final class " + so.type + " extends " + so.type + "_B3 {");
            this.addSuperCall(result, so, "");
            result.add("}");
            result.add("");
        }
        return result;
    }

    public static void padding(List<String> lines, String suffix) {
        for (int p = 0; p < 16; ++p) {
            StringBuilder sb = new StringBuilder();
            sb.append("    private boolean p").append(suffix).append("_").append(p);
            for (int q = 1; q < 16; ++q) {
                sb.append(", p").append(suffix).append("_").append(p).append("_").append(q);
            }
            sb.append(";");
            lines.add(sb.toString());
        }
    }

    public Collection<String> getFields() {
        return Collections.emptyList();
    }

    public StateObject getImplicit(String label) {
        return this.implicits.get(label);
    }

    public Collection<StateObject> getControls() {
        ArrayList<StateObject> s = new ArrayList<StateObject>();
        for (StateObject so : StateObjectHandler.cons(this.args.values())) {
            if (!so.userType.equals(Control.class.getName())) continue;
            s.add(so);
        }
        return s;
    }

    public Collection<String> getAuxResultNames(MethodInfo method) {
        return this.auxNames.get(method.getName());
    }

    public String getAuxResultAccessor(MethodInfo method, String name) {
        return this.auxAccessors.get(method.getName() + name);
    }
}

