/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.contexts.http;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.reactivex.netty.channel.ObservableConnection;
import io.reactivex.netty.client.ClientChannelFactoryImpl;
import io.reactivex.netty.client.ClientConnectionFactory;
import io.reactivex.netty.client.ClientMetricsEvent;
import io.reactivex.netty.client.RxClient;
import io.reactivex.netty.contexts.AbstractClientContextHandler;
import io.reactivex.netty.contexts.ContextsContainer;
import io.reactivex.netty.contexts.RequestCorrelator;
import io.reactivex.netty.metrics.MetricEventsSubject;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import rx.Subscriber;

public class HttpContextClientChannelFactory<I, O>
extends ClientChannelFactoryImpl<HttpClientResponse<O>, HttpClientRequest<I>> {
    private final RequestCorrelator correlator;

    public HttpContextClientChannelFactory(Bootstrap clientBootstrap, RequestCorrelator correlator, MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        super(clientBootstrap, eventsSubject);
        this.correlator = correlator;
    }

    @Override
    public ChannelFuture connect(Subscriber<? super ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>>> subscriber, RxClient.ServerInfo serverInfo, ClientConnectionFactory<HttpClientResponse<O>, HttpClientRequest<I>, ? extends ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>>> connectionFactory) {
        ContextCapturingSubscriber capturingSubscriber = new ContextCapturingSubscriber(subscriber);
        return super.connect(capturingSubscriber, serverInfo, connectionFactory);
    }

    @Override
    public void onNewConnection(ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>> newConnection, Subscriber<? super ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>>> subscriber) {
        ContextCapturingSubscriber subToUse = ContextCapturingSubscriber.class == subscriber.getClass() ? subscriber : new ContextCapturingSubscriber(subscriber);
        super.onNewConnection(newConnection, subToUse);
    }

    private class ContextCapturingSubscriber
    extends Subscriber<ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>>> {
        private final Subscriber<? super ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>>> original;
        private final String requestId;
        private final ContextsContainer container;

        private ContextCapturingSubscriber(Subscriber<? super ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>>> original) {
            super(original);
            this.original = original;
            this.requestId = HttpContextClientChannelFactory.this.correlator.getRequestIdForClientRequest();
            this.container = HttpContextClientChannelFactory.this.correlator.getContextForClientRequest(this.requestId);
        }

        @Override
        public void onCompleted() {
            this.original.onCompleted();
        }

        @Override
        public void onError(Throwable e) {
            this.original.onError(e);
        }

        @Override
        public void onNext(ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>> connection) {
            if (null != this.requestId && null != this.container) {
                connection.getChannel().pipeline().fireUserEventTriggered(new AbstractClientContextHandler.NewContextEvent(this.requestId, this.container));
            }
            this.original.onNext(connection);
        }
    }
}

