/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.ReferenceCountUtil;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.protocol.http.server.ErrorResponseGenerator;
import io.reactivex.netty.protocol.http.server.HttpError;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.reactivex.netty.protocol.http.server.RequestHandler;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

class DefaultErrorResponseGenerator<O>
implements ErrorResponseGenerator<O> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultErrorResponseGenerator.class);
    public static final String STACKTRACE_TEMPLATE_VARIABLE = "${stacktrace}";
    private static final String ERROR_HTML_TEMPLATE = "<!DOCTYPE html>\n<html>\n<head>\n    <title>RxNetty Error Page.</title>\n</head>\n<body>\n    <h1>Unexpected error occured in the server.</h1>\n    <h3>Error</h3>\n    <PRE>  ${stacktrace} </PRE>\n</body>\n</html>";

    DefaultErrorResponseGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateResponse(HttpServerResponse<O> response, Throwable error) {
        if (error instanceof HttpError) {
            response.setStatus(((HttpError)error).getStatus());
        } else {
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        response.getHeaders().set("Content-Type", (Object)"text/html");
        ByteBuf buffer = response.getChannel().alloc().buffer(1024);
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new ByteBufOutputStream(buffer));
            error.printStackTrace(printStream);
            String errorPage = ERROR_HTML_TEMPLATE.replace(STACKTRACE_TEMPLATE_VARIABLE, this.escapeHtml(buffer.toString(Charset.defaultCharset())));
            response.writeString(errorPage);
        }
        finally {
            ReferenceCountUtil.release(buffer);
            if (null != printStream) {
                try {
                    printStream.flush();
                    printStream.close();
                }
                catch (Exception e) {
                    logger.error("Error closing stream for generating error response stacktrace. This is harmless.", e);
                }
            }
        }
    }

    private String escapeHtml(String src) {
        Pattern compile = Pattern.compile("[<>\"&`{}']");
        Matcher matcher = compile.matcher(src);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String rep = matcher.group();
            matcher.appendReplacement(buffer, this.escapeChar(rep));
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private String escapeChar(String c) {
        switch (c.charAt(0)) {
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '&': {
                return "&amp;";
            }
            case '`': {
                return "&#96;";
            }
            case '{': {
                return "&#123;";
            }
            case '}': {
                return "&#125;";
            }
            case '\'': {
                return "&#39;";
            }
        }
        return c;
    }

    public static void main(String[] args) {
        RxNetty.createHttpServer(8888, new RequestHandler<ByteBuf, ByteBuf>(){

            @Override
            public Observable<Void> handle(HttpServerRequest<ByteBuf> request, HttpServerResponse<ByteBuf> response) {
                throw new NullPointerException("doomsday");
            }
        }).startAndWait();
    }
}

