/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.contexts;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import io.reactivex.netty.contexts.ContextsContainer;
import java.util.concurrent.ConcurrentHashMap;

public final class ContextAttributeStorageHelper {
    public static final String CONTAINER_ATTRIBUTE_KEY_NAME = "rxnetty_contexts_container";
    public static final AttributeKey<ConcurrentHashMap<String, ContextsContainer>> CONTAINERS_ATTRIBUTE_KEY = AttributeKey.valueOf("rxnetty_contexts_container");

    private ContextAttributeStorageHelper() {
    }

    public static void setContainer(ChannelHandlerContext ctx, String requestId, ContextsContainer container) {
        if (null == ctx) {
            throw new IllegalArgumentException("Context can not be null.");
        }
        if (null == requestId) {
            throw new IllegalArgumentException("Request id can not be null.");
        }
        if (null == container) {
            throw new IllegalArgumentException("Context container can not be null.");
        }
        ConcurrentHashMap<String, ContextsContainer> containers = ctx.channel().attr(CONTAINERS_ATTRIBUTE_KEY).get();
        if (null == containers) {
            containers = new ConcurrentHashMap();
            ctx.channel().attr(CONTAINERS_ATTRIBUTE_KEY).set(containers);
        }
        containers.put(requestId, container);
    }

    public static ContextsContainer getContainer(ChannelHandlerContext ctx, String requestId) {
        if (null == ctx) {
            throw new IllegalArgumentException("Context can not be null.");
        }
        if (null == requestId) {
            throw new IllegalArgumentException("Request id can not be null.");
        }
        ConcurrentHashMap<String, ContextsContainer> containers = ctx.channel().attr(CONTAINERS_ATTRIBUTE_KEY).get();
        if (null != containers) {
            return containers.get(requestId);
        }
        return null;
    }
}

