/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.contexts;

import io.netty.util.AttributeKey;
import io.netty.util.AttributeMap;
import io.netty.util.DefaultAttributeMap;
import io.reactivex.netty.contexts.ContextsContainer;
import io.reactivex.netty.contexts.RequestCorrelator;
import java.io.PrintStream;
import java.util.Stack;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLocalRequestCorrelator
implements RequestCorrelator {
    private static final Logger logger = LoggerFactory.getLogger(ThreadLocalRequestCorrelator.class);
    protected static final ThreadLocal<ThreadStateHolder> state = new ThreadLocal<ThreadStateHolder>(){

        @Override
        protected ThreadStateHolder initialValue() {
            return new ThreadStateHolder();
        }
    };

    @Override
    public String getRequestIdForClientRequest() {
        return state.get().getRequestId();
    }

    @Override
    public ContextsContainer getContextForClientRequest(String requestId) {
        return state.get().getContainer();
    }

    @Override
    public void onNewServerRequest(String requestId, ContextsContainer contextsContainer) {
        if (null == requestId) {
            throw new IllegalArgumentException("Request Id can not be null.");
        }
        if (null == contextsContainer) {
            throw new IllegalArgumentException("Context container can not be null.");
        }
        state.get().push(new DefaultAttributeMap());
        state.get().setRequestId(requestId);
        state.get().setContainer(contextsContainer);
    }

    @Override
    public void beforeNewClientRequest(String requestId, ContextsContainer contextsContainer) {
        this.onNewServerRequest(requestId, contextsContainer);
    }

    @Override
    public void onClientProcessingEnd(String requestId) {
        state.get().pop();
    }

    @Override
    public void onServerProcessingEnd(String requestId) {
        state.get().pop();
    }

    public static ContextsContainer getCurrentContextContainer() {
        return state.get().getContainer();
    }

    public static String getCurrentRequestId() {
        return state.get().getRequestId();
    }

    @Override
    public <V> Callable<V> makeClosure(final Callable<V> original) {
        final AttributeMap currentState = state.get().peek();
        return new Callable<V>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public V call() throws Exception {
                state.get().push(currentState);
                try {
                    Object v = original.call();
                    return v;
                }
                finally {
                    state.get().pop();
                }
            }
        };
    }

    @Override
    public Runnable makeClosure(final Runnable original) {
        final AttributeMap currentState = state.get().peek();
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                state.get().push(currentState);
                try {
                    original.run();
                }
                finally {
                    state.get().pop();
                }
            }
        };
    }

    public void dumpThreadState() {
        if (logger.isDebugEnabled()) {
            ThreadStateHolder threadStateHolder = state.get();
            logger.debug("******************** Thread Attributes ********************");
            int count = 0;
            for (AttributeMap threadAttribute : threadStateHolder.threadAttributes) {
                logger.debug("Stack level==> " + ++count);
                logger.debug("Request Id: " + threadAttribute.attr(ThreadStateHolder.requestIdKey));
                logger.debug("Context container: " + threadAttribute.attr(ThreadStateHolder.containerKey));
            }
            logger.debug("***********************************************************");
        }
    }

    public void dumpThreadState(PrintStream outputStream) {
        ThreadStateHolder threadStateHolder = state.get();
        outputStream.println("******************** Thread Attributes ********************");
        int count = 0;
        for (AttributeMap threadAttribute : threadStateHolder.threadAttributes) {
            outputStream.println("Stack level==> " + ++count);
            outputStream.println("Request Id: " + threadAttribute.attr(ThreadStateHolder.requestIdKey));
            outputStream.println("Context container: " + threadAttribute.attr(ThreadStateHolder.containerKey));
        }
        outputStream.println("***********************************************************");
    }

    public static final class ThreadStateHolder {
        private static final AttributeKey<String> requestIdKey = AttributeKey.valueOf("rxnetty-contexts-threadlocal-request-id-key");
        private static final AttributeKey<ContextsContainer> containerKey = AttributeKey.valueOf("rxnetty-contexts-threadlocal-context-container-key");
        private final Stack<AttributeMap> threadAttributes = new Stack();

        public void push(AttributeMap map) {
            this.threadAttributes.push(map);
        }

        public AttributeMap pop() {
            return this.threadAttributes.pop();
        }

        public AttributeMap peek() {
            if (this.isEmpty()) {
                return null;
            }
            return this.threadAttributes.peek();
        }

        public boolean isEmpty() {
            return this.threadAttributes.isEmpty();
        }

        public void setRequestId(String requestId) {
            if (!this.isEmpty()) {
                this.peek().attr(requestIdKey).set(requestId);
            }
        }

        public void setContainer(ContextsContainer container) {
            if (!this.isEmpty()) {
                this.peek().attr(containerKey).set(container);
            }
        }

        public String getRequestId() {
            if (this.isEmpty()) {
                return null;
            }
            return this.peek().attr(requestIdKey).get();
        }

        public ContextsContainer getContainer() {
            if (this.isEmpty()) {
                return null;
            }
            return this.peek().attr(containerKey).get();
        }
    }
}

