/*
 * Decompiled with CFR 0.152.
 */
package rx.transformers;

import javafx.application.Platform;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.Action0;
import rx.functions.Action1;

public final class JavaFxTransformers {
    private JavaFxTransformers() {
    }

    public static <T> Observable.Transformer<T, T> doOnNextFx(Action1<T> onNext) {
        return obs -> obs.doOnNext(t -> Platform.runLater(() -> onNext.call(t)));
    }

    public static <T> Observable.Transformer<T, T> doOnErrorFx(Action1<Throwable> onError) {
        return obs -> obs.doOnError(e -> Platform.runLater(() -> onError.call(e)));
    }

    public static <T> Observable.Transformer<T, T> doOnCompletedFx(Action0 onCompleted) {
        return obs -> obs.doOnCompleted(() -> Platform.runLater(() -> ((Action0)onCompleted).call()));
    }

    public static <T> Observable.Transformer<T, T> doOnSubscribeFx(Action0 subscribe) {
        return obs -> obs.doOnSubscribe(() -> Platform.runLater(() -> ((Action0)subscribe).call()));
    }

    public static <T> Observable.Transformer<T, T> doOnTerminateFx(Action0 onTerminate) {
        return obs -> obs.doOnTerminate(() -> Platform.runLater(() -> ((Action0)onTerminate).call()));
    }

    public static <T> Observable.Transformer<T, T> doOnUnsubscribeFx(Action0 onUnsubscribe) {
        return obs -> obs.doOnUnsubscribe(() -> Platform.runLater(() -> ((Action0)onUnsubscribe).call()));
    }

    public static <T> Observable.Transformer<T, T> doOnNextCount(Action1<Integer> onNext) {
        return obs -> obs.lift(new OperatorEmissionCounter(new CountObserver(onNext, null, null)));
    }

    public static <T> Observable.Transformer<T, T> doOnCompletedCount(Action1<Integer> onCompleted) {
        return obs -> obs.lift(new OperatorEmissionCounter(new CountObserver(null, onCompleted, null)));
    }

    public static <T> Observable.Transformer<T, T> doOnErrorCount(Action1<Integer> onError) {
        return obs -> obs.lift(new OperatorEmissionCounter(new CountObserver(null, null, onError)));
    }

    public static <T> Observable.Transformer<T, T> doOnNextCountFx(Action1<Integer> onNext) {
        return obs -> obs.compose(JavaFxTransformers.doOnNextCount((Action1<Integer>)((Action1)i -> Platform.runLater(() -> onNext.call(i)))));
    }

    public static <T> Observable.Transformer<T, T> doOnCompletedCountFx(Action1<Integer> onCompleted) {
        return obs -> obs.compose(JavaFxTransformers.doOnCompletedCount((Action1<Integer>)((Action1)i -> Platform.runLater(() -> onCompleted.call(i)))));
    }

    public static <T> Observable.Transformer<T, T> doOnErrorCountFx(Action1<Integer> onError) {
        return obs -> obs.compose(JavaFxTransformers.doOnErrorCount((Action1<Integer>)((Action1)i -> Platform.runLater(() -> onError.call(i)))));
    }

    private static final class CountObserver {
        private final Action1<Integer> doOnNextCountAction;
        private final Action1<Integer> doOnCompletedCountAction;
        private final Action1<Integer> doOnErrorCountAction;

        CountObserver(Action1<Integer> doOnNextCountAction, Action1<Integer> doOnCompletedCountAction, Action1<Integer> doOnErrorCountAction) {
            this.doOnNextCountAction = doOnNextCountAction;
            this.doOnCompletedCountAction = doOnCompletedCountAction;
            this.doOnErrorCountAction = doOnErrorCountAction;
        }
    }

    private static class OperatorEmissionCounter<T>
    implements Observable.Operator<T, T> {
        private final CountObserver ctObserver;

        OperatorEmissionCounter(CountObserver ctObserver) {
            this.ctObserver = ctObserver;
        }

        public Subscriber<? super T> call(final Subscriber<? super T> child) {
            return new Subscriber<T>(){
                private int count = 0;
                private boolean done = false;

                public void onCompleted() {
                    if (this.done) {
                        return;
                    }
                    try {
                        if (ctObserver.doOnCompletedCountAction != null) {
                            ctObserver.doOnCompletedCountAction.call((Object)this.count);
                        }
                    }
                    catch (Exception e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        this.onError(e);
                        return;
                    }
                    this.done = true;
                    child.onCompleted();
                }

                public void onError(Throwable e) {
                    if (this.done) {
                        return;
                    }
                    try {
                        if (ctObserver.doOnErrorCountAction != null) {
                            ctObserver.doOnErrorCountAction.call((Object)this.count);
                        }
                    }
                    catch (Exception e1) {
                        Exceptions.throwIfFatal((Throwable)e1);
                        child.onError((Throwable)e1);
                    }
                }

                public void onNext(T t) {
                    if (this.done) {
                        return;
                    }
                    try {
                        if (ctObserver.doOnNextCountAction != null) {
                            ctObserver.doOnNextCountAction.call((Object)(++this.count));
                        }
                    }
                    catch (Exception e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        this.onError(e);
                        return;
                    }
                    child.onNext(t);
                }

                public void setProducer(Producer p) {
                    child.setProducer(p);
                }
            };
        }
    }
}

