/*
 * Decompiled with CFR 0.152.
 */
package rx.observables;

import java.util.Map;
import java.util.Objects;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.MenuItem;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import rx.Observable;
import rx.functions.Func1;
import rx.javafx.sources.ActionEventSource;
import rx.javafx.sources.Change;
import rx.javafx.sources.DialogSource;
import rx.javafx.sources.ListChange;
import rx.javafx.sources.MapChange;
import rx.javafx.sources.NodeEventSource;
import rx.javafx.sources.ObservableListSource;
import rx.javafx.sources.ObservableMapSource;
import rx.javafx.sources.ObservableSetSource;
import rx.javafx.sources.ObservableValueSource;
import rx.javafx.sources.SceneEventSource;
import rx.javafx.sources.SetChange;
import rx.javafx.sources.TimerSource;
import rx.javafx.sources.WindowEventSource;

public enum JavaFxObservable {


    public static <T extends Event> Observable<T> eventsOf(Node node, EventType<T> eventType) {
        return NodeEventSource.fromNodeEvents(node, eventType);
    }

    @Deprecated
    public static <T extends Event> Observable<T> fromNodeEvents(Node node, EventType<T> eventType) {
        return JavaFxObservable.eventsOf(node, eventType);
    }

    public static <T> Observable<T> valuesOf(ObservableValue<T> fxObservable) {
        return ObservableValueSource.fromObservableValue(fxObservable);
    }

    public static <T> Observable<T> nonNullValuesOf(ObservableValue<T> fxObservable) {
        return JavaFxObservable.valuesOf(fxObservable).filter(Objects::nonNull);
    }

    @Deprecated
    public static <T> Observable<T> fromObservableValue(ObservableValue<T> fxObservable) {
        return JavaFxObservable.valuesOf(fxObservable);
    }

    public static <T> Observable<Change<T>> changesOf(ObservableValue<T> fxObservable) {
        return ObservableValueSource.fromObservableValueChanges(fxObservable);
    }

    public static <T> Observable<Change<T>> nonNullChangesOf(ObservableValue<T> fxObservable) {
        return JavaFxObservable.changesOf(fxObservable).filter(t -> t.getOldVal() != null && t.getNewVal() != null);
    }

    @Deprecated
    public static <T> Observable<Change<T>> fromObservableValueChanges(ObservableValue<T> fxObservable) {
        return JavaFxObservable.changesOf(fxObservable);
    }

    public static <T extends Event> Observable<T> eventsOf(Scene scene, EventType<T> eventType) {
        return SceneEventSource.fromSceneEvents(scene, eventType);
    }

    @Deprecated
    public static <T extends Event> Observable<T> fromSceneEvents(Scene scene, EventType<T> eventType) {
        return JavaFxObservable.eventsOf(scene, eventType);
    }

    public static <T extends WindowEvent> Observable<T> eventsOf(Window window, EventType<T> eventType) {
        return WindowEventSource.fromWindowEvents(window, eventType);
    }

    @Deprecated
    public static <T extends WindowEvent> Observable<T> fromWindowEvents(Window window, EventType<T> eventType) {
        return JavaFxObservable.eventsOf(window, eventType);
    }

    public static Observable<ActionEvent> actionEventsOf(Node node) {
        return ActionEventSource.fromActionEvents(node);
    }

    @Deprecated
    public static Observable<ActionEvent> fromActionEvents(Node node) {
        return JavaFxObservable.actionEventsOf(node);
    }

    public static Observable<ActionEvent> actionEventsOf(ContextMenu contextMenu) {
        return ActionEventSource.fromActionEvents(contextMenu);
    }

    @Deprecated
    public static Observable<ActionEvent> fromActionEvents(ContextMenu contextMenu) {
        return JavaFxObservable.actionEventsOf(contextMenu);
    }

    public static Observable<ActionEvent> actionEventsOf(MenuItem menuItem) {
        return ActionEventSource.fromActionEvents(menuItem);
    }

    @Deprecated
    public static Observable<ActionEvent> fromActionEvents(MenuItem menuItem) {
        return JavaFxObservable.actionEventsOf(menuItem);
    }

    public static <T> Observable<ObservableList<T>> emitOnChanged(ObservableList<T> source) {
        return ObservableListSource.fromObservableList(source);
    }

    @Deprecated
    public static <T> Observable<ObservableList<T>> fromObservableList(ObservableList<T> source) {
        return JavaFxObservable.emitOnChanged(source);
    }

    public static <T> Observable<T> additionsOf(ObservableList<T> source) {
        return ObservableListSource.fromObservableListAdds(source);
    }

    @Deprecated
    public static <T> Observable<T> fromObservableListAdds(ObservableList<T> source) {
        return JavaFxObservable.additionsOf(source);
    }

    public static <T> Observable<T> removalsOf(ObservableList<T> source) {
        return ObservableListSource.fromObservableListRemovals(source);
    }

    @Deprecated
    public static <T> Observable<T> fromObservableListRemovals(ObservableList<T> source) {
        return JavaFxObservable.removalsOf(source);
    }

    public static <T> Observable<T> updatesOf(ObservableList<T> source) {
        return ObservableListSource.fromObservableListUpdates(source);
    }

    @Deprecated
    public static <T> Observable<T> fromObservableListUpdates(ObservableList<T> source) {
        return JavaFxObservable.updatesOf(source);
    }

    public static <T> Observable<ListChange<T>> changesOf(ObservableList<T> source) {
        return ObservableListSource.fromObservableListChanges(source);
    }

    @Deprecated
    public static <T> Observable<ListChange<T>> fromObservableListChanges(ObservableList<T> source) {
        return JavaFxObservable.changesOf(source);
    }

    public static <T> Observable<ListChange<T>> distinctChangesOf(ObservableList<T> source) {
        return ObservableListSource.fromObservableListDistinctChanges(source);
    }

    @Deprecated
    public static <T> Observable<ListChange<T>> fromObservableListDistinctChanges(ObservableList<T> source) {
        return JavaFxObservable.distinctChangesOf(source);
    }

    public static <T, R> Observable<ListChange<T>> distinctChangesOf(ObservableList<T> source, Func1<T, R> mapper) {
        return ObservableListSource.fromObservableListDistinctChanges(source, mapper);
    }

    @Deprecated
    public static <T, R> Observable<ListChange<T>> fromObservableListDistinctChanges(ObservableList<T> source, Func1<T, R> mapper) {
        return JavaFxObservable.distinctChangesOf(source, mapper);
    }

    public static <T, R> Observable<ListChange<R>> distinctMappingsOf(ObservableList<T> source, Func1<T, R> mapper) {
        return ObservableListSource.fromObservableListDistinctMappings(source, mapper);
    }

    @Deprecated
    public static <T, R> Observable<ListChange<R>> fromObservableListDistinctMappings(ObservableList<T> source, Func1<T, R> mapper) {
        return JavaFxObservable.distinctMappingsOf(source, mapper);
    }

    public static <K, T> Observable<ObservableMap<K, T>> emitOnChanged(ObservableMap<K, T> source) {
        return ObservableMapSource.fromObservableMap(source);
    }

    @Deprecated
    public static <K, T> Observable<ObservableMap<K, T>> fromObservableMap(ObservableMap<K, T> source) {
        return JavaFxObservable.emitOnChanged(source);
    }

    public static <K, T> Observable<Map.Entry<K, T>> additionsOf(ObservableMap<K, T> source) {
        return ObservableMapSource.fromObservableMapAdds(source);
    }

    @Deprecated
    public static <K, T> Observable<Map.Entry<K, T>> fromObservableMapAdds(ObservableMap<K, T> source) {
        return JavaFxObservable.additionsOf(source);
    }

    public static <K, T> Observable<Map.Entry<K, T>> removalsOf(ObservableMap<K, T> source) {
        return ObservableMapSource.fromObservableMapRemovals(source);
    }

    @Deprecated
    public static <K, T> Observable<Map.Entry<K, T>> fromObservableMapRemovals(ObservableMap<K, T> source) {
        return JavaFxObservable.removalsOf(source);
    }

    public static <K, T> Observable<MapChange<K, T>> changesOf(ObservableMap<K, T> source) {
        return ObservableMapSource.fromObservableMapChanges(source);
    }

    @Deprecated
    public static <K, T> Observable<MapChange<K, T>> fromObservableMapChanges(ObservableMap<K, T> source) {
        return JavaFxObservable.changesOf(source);
    }

    public static <T> Observable<ObservableSet<T>> emitOnChanged(ObservableSet<T> source) {
        return ObservableSetSource.fromObservableSet(source);
    }

    @Deprecated
    public static <T> Observable<ObservableSet<T>> fromObservableSet(ObservableSet<T> source) {
        return JavaFxObservable.emitOnChanged(source);
    }

    public static <T> Observable<T> additionsOf(ObservableSet<T> source) {
        return ObservableSetSource.fromObservableSetAdds(source);
    }

    @Deprecated
    public static <T> Observable<T> fromObservableSetAdds(ObservableSet<T> source) {
        return JavaFxObservable.additionsOf(source);
    }

    public static <T> Observable<T> removalsOf(ObservableSet<T> source) {
        return ObservableSetSource.fromObservableSetRemovals(source);
    }

    @Deprecated
    public static <T> Observable<T> fromObservableSetRemovals(ObservableSet<T> source) {
        return JavaFxObservable.removalsOf(source);
    }

    public static <T> Observable<SetChange<T>> changesOf(ObservableSet<T> source) {
        return ObservableSetSource.fromObservableSetChanges(source);
    }

    @Deprecated
    public static <T> Observable<SetChange<T>> fromObservableSetChanges(ObservableSet<T> source) {
        return JavaFxObservable.changesOf(source);
    }

    public static Observable<Long> interval(Duration duration) {
        return TimerSource.interval(duration);
    }

    public static <T> Observable<T> fromDialog(Dialog<T> dialog) {
        return DialogSource.fromDialogSource(dialog);
    }
}

