/*
 * Decompiled with CFR 0.152.
 */
package rx.javafx.sources;

import java.util.Arrays;
import rx.Observable;
import rx.Subscription;
import rx.subjects.PublishSubject;
import rx.subjects.SerializedSubject;
import rx.subscriptions.CompositeSubscription;

public final class CompositeObservable<T> {
    private final SerializedSubject<T, T> subject = PublishSubject.create().toSerialized();
    private final Observable<T> output;

    public CompositeObservable() {
        this(null);
    }

    public CompositeObservable(Observable.Transformer<T, T> transformer) {
        Observable updatingSource = this.subject.asObservable();
        this.output = transformer == null ? updatingSource : updatingSource.compose(transformer);
    }

    public Observable<T> toObservable() {
        return this.output;
    }

    public Subscription add(Observable<T> observable) {
        return observable.subscribe(this.subject);
    }

    public CompositeSubscription addAll(Observable<T> ... observables) {
        CompositeSubscription subscriptions = new CompositeSubscription();
        Arrays.stream(observables).map(this::add).forEach(arg_0 -> ((CompositeSubscription)subscriptions).add(arg_0));
        return subscriptions;
    }
}

