/*
 * Decompiled with CFR 0.152.
 */
package rx.javafx.sources;

import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rx.Observable;
import rx.observables.JavaFxObservable;

public final class CompositeObservable<T> {
    private final ObservableList<Observable<T>> sources;
    private final int initialCapacity;

    public CompositeObservable() {
        this(-1);
    }

    public CompositeObservable(int initialCapacity) {
        this.initialCapacity = initialCapacity;
        this.sources = FXCollections.synchronizedObservableList((ObservableList)FXCollections.observableArrayList());
    }

    public Observable<T> toObservable() {
        Observable updatingSource = Observable.merge((Observable)Observable.from(this.sources).flatMap(obs -> obs.takeWhile(v -> this.sources.contains(obs))), (Observable)JavaFxObservable.fromObservableListAdds(this.sources).flatMap(obs -> obs.takeWhile(v -> this.sources.contains(obs))));
        if (this.initialCapacity > 0) {
            return updatingSource.cacheWithInitialCapacity(this.initialCapacity);
        }
        return updatingSource;
    }

    public void add(Observable<T> observable) {
        this.sources.add(observable);
    }

    public void remove(Observable<T> observable) {
        this.sources.remove(observable);
    }
}

