/*
 * Decompiled with CFR 0.152.
 */
package rx.javafx.sources;

import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import rx.Observable;
import rx.Scheduler;
import rx.javafx.sources.Flag;
import rx.javafx.sources.SetChange;
import rx.schedulers.JavaFxScheduler;
import rx.subscriptions.JavaFxSubscriptions;

public final class ObservableSetSource {
    private ObservableSetSource() {
    }

    public static <T> Observable<ObservableSet<T>> fromObservableSet(ObservableSet<T> source) {
        return Observable.create(subscriber -> {
            subscriber.onNext((Object)source);
            SetChangeListener listener = c -> subscriber.onNext((Object)source);
            subscriber.add(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        }).startWith(source).subscribeOn((Scheduler)JavaFxScheduler.getInstance());
    }

    public static <T> Observable<T> fromObservableSetAdds(ObservableSet<T> source) {
        return Observable.create(subscriber -> {
            SetChangeListener listener = c -> {
                if (c.wasAdded()) {
                    subscriber.onNext(c.getElementAdded());
                }
            };
            source.addListener(listener);
            subscriber.add(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        }).subscribeOn((Scheduler)JavaFxScheduler.getInstance());
    }

    public static <T> Observable<T> fromObservableSetRemovals(ObservableSet<T> source) {
        return Observable.create(subscriber -> {
            SetChangeListener listener = c -> {
                if (c.wasRemoved()) {
                    subscriber.onNext(c.getElementRemoved());
                }
            };
            source.addListener(listener);
            subscriber.add(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        }).subscribeOn((Scheduler)JavaFxScheduler.getInstance());
    }

    public static <T> Observable<SetChange<T>> fromObservableSetChanges(ObservableSet<T> source) {
        return Observable.create(subscriber -> {
            SetChangeListener listener = c -> {
                if (c.wasRemoved()) {
                    subscriber.onNext(new SetChange<Object>(c.getElementRemoved(), Flag.REMOVED));
                }
                if (c.wasAdded()) {
                    subscriber.onNext(new SetChange<Object>(c.getElementAdded(), Flag.ADDED));
                }
            };
            source.addListener(listener);
            subscriber.add(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        }).subscribeOn((Scheduler)JavaFxScheduler.getInstance());
    }
}

