/*
 * Decompiled with CFR 0.152.
 */
package rx.observables;

import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import rx.Observable;
import rx.functions.Func1;
import rx.javafx.sources.ActionEventSource;
import rx.javafx.sources.Change;
import rx.javafx.sources.ListChange;
import rx.javafx.sources.NodeEventSource;
import rx.javafx.sources.ObservableListSource;
import rx.javafx.sources.ObservableValueSource;
import rx.javafx.sources.SceneEventSource;
import rx.javafx.sources.WindowEventSource;

public enum JavaFxObservable {


    public static <T extends Event> Observable<T> fromNodeEvents(Node node, EventType<T> eventType) {
        return NodeEventSource.fromNodeEvents(node, eventType);
    }

    public static <T> Observable<T> fromObservableValue(ObservableValue<T> fxObservable) {
        return ObservableValueSource.fromObservableValue(fxObservable);
    }

    public static <T> Observable<Change<T>> fromObservableValueChanges(ObservableValue<T> fxObservable) {
        return ObservableValueSource.fromObservableValueChanges(fxObservable);
    }

    public static <T extends Event> Observable<T> fromSceneEvents(Scene scene, EventType<T> eventType) {
        return SceneEventSource.fromSceneEvents(scene, eventType);
    }

    public static <T extends WindowEvent> Observable<T> fromWindowEvents(Window window, EventType<T> eventType) {
        return WindowEventSource.fromWindowEvents(window, eventType);
    }

    public static Observable<ActionEvent> fromActionEvents(Node node) {
        return ActionEventSource.fromActionEvents(node);
    }

    public static Observable<ActionEvent> fromActionEvents(ContextMenu contextMenu) {
        return ActionEventSource.fromActionEvents(contextMenu);
    }

    public static Observable<ActionEvent> fromActionEvents(MenuItem menuItem) {
        return ActionEventSource.fromActionEvents(menuItem);
    }

    public static <T> Observable<ObservableList<T>> fromObservableList(ObservableList<T> source) {
        return ObservableListSource.fromObservableList(source);
    }

    public static <T> Observable<T> fromObservableListAdds(ObservableList<T> source) {
        return ObservableListSource.fromObservableListAdds(source);
    }

    public static <T> Observable<T> fromObservableListRemovals(ObservableList<T> source) {
        return ObservableListSource.fromObservableListRemovals(source);
    }

    public static <T> Observable<T> fromObservableListUpdates(ObservableList<T> source) {
        return ObservableListSource.fromObservableListUpdates(source);
    }

    public static <T> Observable<ListChange<T>> fromObservableListChanges(ObservableList<T> source) {
        return ObservableListSource.fromObservableListChanges(source);
    }

    public static <T> Observable<ListChange<T>> fromObservableListDistinctChanges(ObservableList<T> source) {
        return ObservableListSource.fromObservableListDistinctChanges(source);
    }

    public static <T, R> Observable<ListChange<T>> fromObservableListDistinctChanges(ObservableList<T> source, Func1<T, R> mapper) {
        return ObservableListSource.fromObservableListDistinctChanges(source, mapper);
    }

    public static <T, R> Observable<ListChange<R>> fromObservableListDistinctMappings(ObservableList<T> source, Func1<T, R> mapper) {
        return ObservableListSource.fromObservableListDistinctMappings(source, mapper);
    }
}

