/*
 * Decompiled with CFR 0.152.
 */
package rx.javafx.sources;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.javafx.sources.NodeEventSource;
import rx.schedulers.JavaFxScheduler;
import rx.subscriptions.JavaFxSubscriptions;

public final class ActionEventSource {
    private ActionEventSource() {
    }

    public static Observable<ActionEvent> fromActionEvents(Node node) {
        return NodeEventSource.fromNodeEvents(node, ActionEvent.ACTION);
    }

    public static Observable<ActionEvent> fromActionEvents(ContextMenu source) {
        return Observable.create(subscriber -> {
            EventHandler handler = arg_0 -> ((Subscriber)subscriber).onNext(arg_0);
            source.addEventHandler(ActionEvent.ANY, handler);
            subscriber.add(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeEventHandler(ActionEvent.ANY, handler)));
        }).subscribeOn((Scheduler)JavaFxScheduler.getInstance());
    }

    public static Observable<ActionEvent> fromActionEvents(MenuItem source) {
        return Observable.create(subscriber -> {
            EventHandler handler = arg_0 -> ((Subscriber)subscriber).onNext(arg_0);
            source.addEventHandler(ActionEvent.ANY, handler);
            subscriber.add(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeEventHandler(ActionEvent.ANY, handler)));
        }).subscribeOn((Scheduler)JavaFxScheduler.getInstance());
    }
}

