/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import java.util.concurrent.TimeUnit;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.util.Duration;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.subscriptions.BooleanSubscription;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.Subscriptions;

public final class JavaFxScheduler
extends Scheduler {
    private static final JavaFxScheduler INSTANCE = new JavaFxScheduler();

    JavaFxScheduler() {
    }

    public static JavaFxScheduler getInstance() {
        return INSTANCE;
    }

    public Scheduler.Worker createWorker() {
        return new InnerJavaFxScheduler();
    }

    private static class InnerJavaFxScheduler
    extends Scheduler.Worker {
        private final CompositeSubscription innerSubscription = new CompositeSubscription();

        private InnerJavaFxScheduler() {
        }

        public void unsubscribe() {
            this.innerSubscription.unsubscribe();
        }

        public boolean isUnsubscribed() {
            return this.innerSubscription.isUnsubscribed();
        }

        public Subscription schedule(final Action0 action, long delayTime, TimeUnit unit) {
            final BooleanSubscription s = BooleanSubscription.create();
            long delay = unit.toMillis(Math.max(delayTime, 0L));
            final Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)delay), (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    if (innerSubscription.isUnsubscribed() || s.isUnsubscribed()) {
                        return;
                    }
                    action.call();
                    innerSubscription.remove((Subscription)s);
                }
            }, new KeyValue[0])});
            timeline.setCycleCount(1);
            timeline.play();
            this.innerSubscription.add((Subscription)s);
            return Subscriptions.create((Action0)new Action0(){

                public void call() {
                    timeline.stop();
                    s.unsubscribe();
                    innerSubscription.remove((Subscription)s);
                }
            });
        }

        public Subscription schedule(final Action0 action) {
            final BooleanSubscription s = BooleanSubscription.create();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (innerSubscription.isUnsubscribed() || s.isUnsubscribed()) {
                        return;
                    }
                    action.call();
                    innerSubscription.remove((Subscription)s);
                }
            });
            this.innerSubscription.add((Subscription)s);
            return Subscriptions.create((Action0)new Action0(){

                public void call() {
                    s.unsubscribe();
                    innerSubscription.remove((Subscription)s);
                }
            });
        }
    }
}

