/*
 * Decompiled with CFR 0.152.
 */
package rx.javafx.sources;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;
import rx.subscriptions.JavaFxSubscriptions;

public class ObservableValueSource {
    public static <T> Observable<T> fromObservableValue(final ObservableValue<T> fxObservable) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(){

            public void call(final Subscriber<? super T> subscriber) {
                subscriber.onNext(fxObservable.getValue());
                final ChangeListener listener = new ChangeListener<T>(){

                    public void changed(ObservableValue<? extends T> observableValue, T prev, T current) {
                        subscriber.onNext(current);
                    }
                };
                fxObservable.addListener(listener);
                subscriber.add(JavaFxSubscriptions.unsubscribeInEventDispatchThread(new Action0(){

                    public void call() {
                        fxObservable.removeListener(listener);
                    }
                }));
            }
        });
    }
}

