/*
 * Decompiled with CFR 0.152.
 */
package rx.javafx.sources;

import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.schedulers.JavaFxScheduler;
import rx.subscriptions.JavaFxSubscriptions;

public class NodeEventSource {
    public static <T extends Event> Observable<T> fromNodeEvents(final Node source, final EventType<T> eventType) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(){

            public void call(final Subscriber<? super T> subscriber) {
                final EventHandler handler = new EventHandler<T>(){

                    public void handle(T t) {
                        subscriber.onNext(t);
                    }
                };
                source.addEventHandler(eventType, handler);
                subscriber.add(JavaFxSubscriptions.unsubscribeInEventDispatchThread(new Action0(){

                    public void call() {
                        source.removeEventHandler(eventType, handler);
                    }
                }));
            }
        }).subscribeOn((Scheduler)JavaFxScheduler.getInstance());
    }
}

