/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.reactivestreams;

import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import rx.Single;
import rx.SingleSubscriber;

public final class SingleAsPublisher<T>
implements Publisher<T> {
    final Single<T> single;

    public SingleAsPublisher(Single<T> single) {
        this.single = single;
    }

    public void subscribe(Subscriber<? super T> s) {
        SingleAsPublisherSubscriber<? super T> parent = new SingleAsPublisherSubscriber<T>(s);
        s.onSubscribe(parent);
        this.single.subscribe(parent);
    }

    static final class SingleAsPublisherSubscriber<T>
    extends SingleSubscriber<T>
    implements Subscription {
        final Subscriber<? super T> actual;
        final AtomicInteger state;
        T value;
        volatile boolean cancelled;
        static final int NO_REQUEST_NO_VALUE = 0;
        static final int NO_REQUEST_HAS_VALUE = 1;
        static final int HAS_REQUEST_NO_VALUE = 2;
        static final int HAS_REQUEST_HAS_VALUE = 3;

        public SingleAsPublisherSubscriber(Subscriber<? super T> actual) {
            this.actual = actual;
            this.state = new AtomicInteger();
        }

        public void onSuccess(T value) {
            int s;
            if (this.cancelled) {
                return;
            }
            if (value == null) {
                this.state.lazySet(3);
                this.actual.onError((Throwable)new NullPointerException("value"));
                return;
            }
            while ((s = this.state.get()) != 1 && s != 3 && !this.cancelled) {
                if (s == 2) {
                    this.actual.onNext(value);
                    if (this.cancelled) continue;
                    this.actual.onComplete();
                    continue;
                }
                this.value = value;
                if (!this.state.compareAndSet(s, 1)) continue;
                break;
            }
        }

        public void onError(Throwable error) {
            if (this.cancelled) {
                return;
            }
            this.state.lazySet(3);
            this.actual.onError(error);
        }

        public void request(long n) {
            if (n > 0L) {
                int s;
                while ((s = this.state.get()) != 3 && s != 2 && !this.cancelled) {
                    if (s != 1) continue;
                    if (!this.state.compareAndSet(s, 3)) break;
                    T v = this.value;
                    this.value = null;
                    this.actual.onNext(v);
                    if (this.cancelled) break;
                    this.actual.onComplete();
                    break;
                }
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                if (this.state.getAndSet(3) == 1) {
                    this.value = null;
                }
                this.unsubscribe();
            }
        }
    }
}

