/*
 * Decompiled with CFR 0.152.
 */
package rx.math.operators;

import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;

public final class OperatorAverageFloat<T>
implements Observable.Operator<Float, T> {
    final Func1<? super T, Float> valueExtractor;

    public OperatorAverageFloat(Func1<? super T, Float> valueExtractor) {
        this.valueExtractor = valueExtractor;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super Float> child) {
        return new AverageObserver(child);
    }

    private final class AverageObserver
    extends Subscriber<T> {
        final Subscriber<? super Float> child;
        float sum;
        int count;

        public AverageObserver(Subscriber<? super Float> subscriber) {
            super(subscriber);
            this.child = subscriber;
        }

        @Override
        public void onNext(T args) {
            this.sum += OperatorAverageFloat.this.valueExtractor.call(args).floatValue();
            ++this.count;
        }

        @Override
        public void onError(Throwable e) {
            this.child.onError(e);
        }

        @Override
        public void onCompleted() {
            if (this.count > 0) {
                try {
                    this.child.onNext(Float.valueOf(this.sum / (float)this.count));
                }
                catch (Throwable t) {
                    this.child.onError(t);
                    return;
                }
                this.child.onCompleted();
            } else {
                this.child.onError(new IllegalArgumentException("Sequence contains no elements"));
            }
        }
    }
}

