/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.operators.DebugSubscriber;
import rx.plugins.DebugNotification;
import rx.plugins.DebugNotificationListener;

final class DebugSubscription<T, C>
implements Subscription {
    private final DebugSubscriber<T, C> debugObserver;
    private DebugNotificationListener<C> listener;

    DebugSubscription(DebugSubscriber<T, C> debugObserver, DebugNotificationListener<C> listener) {
        this.debugObserver = debugObserver;
        this.listener = listener;
    }

    public void unsubscribe() {
        DebugNotification<T> n = DebugNotification.createUnsubscribe(this.debugObserver.getActual(), this.debugObserver.getFrom(), this.debugObserver.getTo());
        C context = this.listener.start(n);
        try {
            this.debugObserver.unsubscribe();
            this.listener.complete(context);
        }
        catch (Throwable e) {
            this.listener.error(context, e);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public boolean isUnsubscribed() {
        return this.debugObserver.isUnsubscribed();
    }
}

