/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClassUtils {
    private static final boolean USE_SEPARATE_CLASSLOADER = Boolean.getBoolean("jmh.separateClassLoader");

    private ClassUtils() {
    }

    public static List<Method> enumerateMethods(Class<?> clazz) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            result.addAll(Arrays.asList(current.getDeclaredMethods()));
        }
        return result;
    }

    public static Class<?> loadClass(String className) {
        try {
            if (!USE_SEPARATE_CLASSLOADER) {
                return Class.forName(className);
            }
            String classPathValue = System.getProperty("java.class.path");
            String[] classPath = classPathValue.split(File.pathSeparator);
            URL[] classPathUrl = new URL[classPath.length];
            for (int i = 0; i < classPathUrl.length; ++i) {
                try {
                    classPathUrl[i] = new File(classPath[i]).toURI().toURL();
                    continue;
                }
                catch (MalformedURLException ex) {
                    throw new RuntimeException("Error parsing the value of property java.class.path: " + classPathValue, ex);
                }
            }
            URLClassLoader loader = new URLClassLoader(classPathUrl);
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Benchmark does not match a class", ex);
        }
    }

    public static Map<String, String> denseClassNames(Collection<String> src) {
        if (src.isEmpty()) {
            return Collections.emptyMap();
        }
        int maxLen = Integer.MIN_VALUE;
        for (String s : src) {
            maxLen = Math.max(maxLen, s.length());
        }
        String[] prefix = new String[]{};
        for (String s : src) {
            String[] names = s.split("\\.");
            if (prefix.length == 0) {
                prefix = names;
                continue;
            }
            int prefixRun = 0;
            int c = 0;
            while (c < Math.min(prefix.length, names.length) && names[c].equals(prefix[c])) {
                ++c;
                ++prefixRun;
            }
            prefix = Arrays.copyOf(prefix, prefixRun);
        }
        for (int c = 0; c < prefix.length && prefix[c].toLowerCase().equals(prefix[c]); ++c) {
            prefix[c] = String.valueOf(prefix[c].charAt(0));
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String s : src) {
            int prefixLen = prefix.length;
            String[] names = s.split("\\.");
            System.arraycopy(prefix, 0, names, 0, prefixLen);
            String dense = "";
            for (String n : names) {
                dense = dense + n + ".";
            }
            if (dense.endsWith(".")) {
                dense = dense.substring(0, dense.length() - 1);
            }
            result.put(s, dense);
        }
        return result;
    }
}

