/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Func0;
import rx.subscriptions.SerialSubscription;

public final class OperatorWhileDoWhile<T>
implements Observable.OnSubscribe<T> {
    final Func0<Boolean> preCondition;
    final Func0<Boolean> postCondition;
    final Observable<? extends T> source;

    public OperatorWhileDoWhile(Observable<? extends T> source, Func0<Boolean> preCondition, Func0<Boolean> postCondition) {
        this.source = source;
        this.preCondition = preCondition;
        this.postCondition = postCondition;
    }

    public void call(Subscriber<? super T> child) {
        boolean first;
        try {
            first = (Boolean)this.preCondition.call();
        }
        catch (Throwable t) {
            child.onError(t);
            return;
        }
        if (first) {
            SerialSubscription cancel = new SerialSubscription();
            child.add((Subscription)cancel);
            final SourceObserver sourceObserver = new SourceObserver(child, cancel);
            Subscriber firstSubscription = new Subscriber<T>(){

                public void onCompleted() {
                    sourceObserver.onCompleted();
                }

                public void onError(Throwable e) {
                    sourceObserver.onError(e);
                }

                public void onNext(T t) {
                    sourceObserver.onNext(t);
                }
            };
            cancel.set((Subscription)firstSubscription);
            this.source.unsafeSubscribe(firstSubscription);
        } else {
            child.onCompleted();
        }
    }

    final class SourceObserver
    implements Observer<T> {
        final Subscriber<? super T> actual;
        final SerialSubscription cancel;

        public SourceObserver(Subscriber<? super T> actual, SerialSubscription cancel) {
            this.actual = actual;
            this.cancel = cancel;
        }

        public void onNext(T args) {
            this.actual.onNext(args);
        }

        public void onError(Throwable e) {
            this.actual.onError(e);
        }

        public void onCompleted() {
            boolean next;
            try {
                next = (Boolean)OperatorWhileDoWhile.this.postCondition.call();
            }
            catch (Throwable t) {
                this.actual.onError(t);
                return;
            }
            if (next) {
                Subscriber newSubscription = new Subscriber<T>(){

                    public void onCompleted() {
                        SourceObserver.this.onCompleted();
                    }

                    public void onError(Throwable e) {
                        SourceObserver.this.onError(e);
                    }

                    public void onNext(T t) {
                        SourceObserver.this.onNext(t);
                    }
                };
                this.cancel.set((Subscription)newSubscription);
                OperatorWhileDoWhile.this.source.unsafeSubscribe(newSubscription);
            } else {
                this.actual.onCompleted();
            }
        }
    }
}

