/*
 * Decompiled with CFR 0.152.
 */
package rx;

import java.util.Map;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Func0;
import rx.operators.OperatorIfThen;
import rx.operators.OperatorSwitchCase;
import rx.operators.OperatorWhileDoWhile;

public final class Statement {
    private static final Func0True TRUE = new Func0True();

    private Statement() {
        throw new IllegalStateException("No instances!");
    }

    public static <K, R> Observable<R> switchCase(Func0<? extends K> caseSelector, Map<? super K, ? extends Observable<? extends R>> mapOfCases) {
        return Statement.switchCase(caseSelector, mapOfCases, Observable.empty());
    }

    public static <K, R> Observable<R> switchCase(Func0<? extends K> caseSelector, Map<? super K, ? extends Observable<? extends R>> mapOfCases, Scheduler scheduler) {
        return Statement.switchCase(caseSelector, mapOfCases, Observable.empty().subscribeOn(scheduler));
    }

    public static <K, R> Observable<R> switchCase(Func0<? extends K> caseSelector, Map<? super K, ? extends Observable<? extends R>> mapOfCases, Observable<? extends R> defaultCase) {
        return Observable.create(new OperatorSwitchCase<K, R>(caseSelector, mapOfCases, defaultCase));
    }

    public static <T> Observable<T> doWhile(Observable<? extends T> source, Func0<Boolean> postCondition) {
        return Observable.create(new OperatorWhileDoWhile<T>(source, TRUE, postCondition));
    }

    public static <T> Observable<T> whileDo(Observable<? extends T> source, Func0<Boolean> preCondition) {
        return Observable.create(new OperatorWhileDoWhile<T>(source, preCondition, preCondition));
    }

    public static <R> Observable<R> ifThen(Func0<Boolean> condition, Observable<? extends R> then) {
        return Statement.ifThen(condition, then, Observable.empty());
    }

    public static <R> Observable<R> ifThen(Func0<Boolean> condition, Observable<? extends R> then, Scheduler scheduler) {
        return Statement.ifThen(condition, then, Observable.empty().subscribeOn(scheduler));
    }

    public static <R> Observable<R> ifThen(Func0<Boolean> condition, Observable<? extends R> then, Observable<? extends R> orElse) {
        return Observable.create(new OperatorIfThen<R>(condition, then, orElse));
    }

    private static final class Func0True
    implements Func0<Boolean> {
        private Func0True() {
        }

        public Boolean call() {
            return true;
        }
    }
}

