/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.Map;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func0;

public final class OperatorSwitchCase<K, R>
implements Observable.OnSubscribe<R> {
    final Func0<? extends K> caseSelector;
    final Map<? super K, ? extends Observable<? extends R>> mapOfCases;
    final Observable<? extends R> defaultCase;

    public OperatorSwitchCase(Func0<? extends K> caseSelector, Map<? super K, ? extends Observable<? extends R>> mapOfCases, Observable<? extends R> defaultCase) {
        this.caseSelector = caseSelector;
        this.mapOfCases = mapOfCases;
        this.defaultCase = defaultCase;
    }

    @Override
    public void call(Subscriber<? super R> t1) {
        Observable<R> target;
        try {
            K caseKey = this.caseSelector.call();
            target = this.mapOfCases.containsKey(caseKey) ? this.mapOfCases.get(caseKey) : this.defaultCase;
        }
        catch (Throwable t) {
            t1.onError(t);
            return;
        }
        target.subscribe(t1);
    }
}

