/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import rx.Observable;
import rx.Subscriber;

public final class OperatorToObservableList<T>
implements Observable.Operator<List<T>, T> {
    @Override
    public Subscriber<? super T> call(final Subscriber<? super List<T>> o) {
        return new Subscriber<T>(o){
            private boolean completed;
            final List<T> list;
            {
                super(x0);
                this.completed = false;
                this.list = new LinkedList();
            }

            @Override
            public void onStart() {
                this.request(Long.MAX_VALUE);
            }

            @Override
            public void onCompleted() {
                try {
                    this.completed = true;
                    o.onNext(new ArrayList(this.list));
                    o.onCompleted();
                }
                catch (Throwable e) {
                    this.onError(e);
                }
            }

            @Override
            public void onError(Throwable e) {
                o.onError(e);
            }

            @Override
            public void onNext(T value) {
                if (!this.completed) {
                    this.list.add(value);
                }
            }
        };
    }
}

